
#include "mbed.h"
#include "USBHost.h"
#include "AndroidAccessory.h"


//device setup

PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

InterruptIn  sw1(p21);
InterruptIn  sw2(p22);
InterruptIn  sw3(p23);


/*
DigitalIn sw1(p21);
DigitalIn sw2(p22);
DigitalIn sw3(p23);
*/



class Demokit :public AndroidAccessory {
public:
    Demokit():AndroidAccessory(3,3,
                                       "Google, Inc.",
                                       "DemoKit",
                                       "DemoKit Arduino Board",
                                       "1.0",
                                       "http://www.android.com",
                                       "0000000012345678") {};
    virtual int callbackRead(u8 *buff, int len);
    virtual void setupDevice();
    virtual void resetDevice();
    void switchchk();
private:

    u8 sw1b,sw2b,sw3b; //swich data
};



void Demokit::setupDevice() {
    sw1.mode(PullUp);
    sw2.mode(PullUp);
    sw3.mode(PullUp);
    sw1.rise(this,&Demokit::switchchk);
    sw1.fall(this,&Demokit::switchchk);
    sw2.rise(this,&Demokit::switchchk);
    sw2.fall(this,&Demokit::switchchk);
    sw3.rise(this,&Demokit::switchchk);
    sw3.fall(this,&Demokit::switchchk);
    sw1b=sw2b=sw3b=sw1;

}


void Demokit::resetDevice() {
    led1=0;
    led2=0;
    led3=0;
    led4=0;
}

int Demokit::callbackRead(u8 *buf, int len) {


    if (buf[0] == 0x2) {
        if (buf[1] == 0x0) {
            log("led1=%d\r\n",buf[2]);
            led1=((float)buf[2])/255.0;
        } else if (buf[1]==0x3) {
            led2=((float)buf[2])/255.0;
        } else if (buf[1]==0x6) {
            led3=((float)buf[2])/255.0;
        }
    } else if (buf[0] ==0x3) {
        if (buf[1] == 0x0) {
            led4=buf[2]? 1.0:0.0;
        }
    }

    return 0;
}

void Demokit::switchchk() {
    log("Demokit::switchchk()\r\n");
    //int ret;
    __disable_irq();


    u8* wbuf=_writebuff;
    wbuf[0]=0x01;
    //switch1
    if (sw1!=sw1b) {
        log("sw1=%d\r\n",sw1.read());
        wbuf[1]=0;
        wbuf[2]=!sw1;
        this->write();
        wait_ms(4);
        sw1b=sw1;
        //w_flag=true;
    }
    //switch2
    else if (sw2!=sw2b) {
        log("sw2=%d\r\n",sw2.read());
        wbuf[1]=1;
        wbuf[2]=!sw2;
        this->write();
        wait_ms(4);
        sw2b=sw2;
        //w_flag=true;
    }
    //switch3
    else if (sw3!=sw3b) {
        log("sw3=%d\r\n",sw3.read());
        wbuf[1]=2;
        wbuf[2]=!sw3;
        this->write();
        wait_ms(4);
        sw3b=sw3;
        // w_flag=true;
    }

    else {
        wbuf[0]=wbuf[1]=wbuf[2]=0;
        this->write();
        wait_ms(4);
    }
    
    __enable_irq();
}



Demokit demokit;

int main() {
    printf("Android Development Kit: start\r\n");
    USBInit();
    while (1) {
        USBLoop();
        //if(demokit.read(demokit._readbuff,demokit._readbuffsize)<0)demokit.adkEnd();
    }

}
