
#ifndef ADK_H_INCLUDED
#define ADK_H_INCLUDED

#include "mbed.h"


#define ACCESSORY_STRING_MANUFACTURER   0
#define ACCESSORY_STRING_MODEL          1
#define ACCESSORY_STRING_DESCRIPTION    2
#define ACCESSORY_STRING_VERSION        3
#define ACCESSORY_STRING_URI            4
#define ACCESSORY_STRING_SERIAL         5

#define ACCESSORY_GET_PROTOCOL          51
#define ACCESSORY_SEND_STRING           52
#define ACCESSORY_START                 53


//void sendString(int device, int index, const char *str);
//int getProtocol(int device);
bool switchDevice(int device);

class AdkUSB
{
    public:
    AdkUSB(int device, int configuration, int interfaceNumber);
    int read(u8 *buff, int len, int nakLimit);
    int write(u8 *buff, int len );
    void loop();
    
    private:
    int input_ep;
    int output_ep;
    int _device;
    int _configuration;
    int _interfaceNumber;

  
};



#endif