#include <stdio.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "USBHost.h"
#include "Utils.h"
#include "ps3.h"
#include "ADK.h"
#include "mbed.h"

#define  ADKLOG 1
#if ADKLOG
#define  LOG(...)       printf(__VA_ARGS__)
#define  Log(...)       printf(__VA_ARGS__)
#define  log(...)       printf(__VA_ARGS__)

#else
#define  LOG(...)       do {} while(0)
#define  Log(...)       do {} while(0)
#define  log(...)       do {} while(0)

#endif

//const manufacturer=


PwmOut led1(LED1);
PwmOut led2(LED2);
PwmOut led3(LED3);
PwmOut led4(LED4);

void AdkUSB::loop() {
    u8 buf[3];

    while (1) {
        //wait_ms(10);
        //printf("Adk.read run!-------------------------xxxxxxxxxxxxxxxxxxxxxxxx\r\n");
        int len=this->read(buf,sizeof(buf),1);
        if (len >0) {
            log("buf[0]=%d,buf[1]=%d,buf[2]=%d\r\n",buf[0],buf[1],buf[2]);
            if (buf[0] == 0x2) {
                if (buf[1] == 0x0) {
                    led1=((float)buf[2])/255.0;
                } else if (buf[1]==0x3) {
                    led2=((float)buf[2])/255.0;
                } else if (buf[1]==0x6) {
                    led3=((float)buf[2])/255.0;
                }
            } else if (buf[0] ==0x3) {
                if (buf[1] == 0x0) {
                    led4=buf[2]? 1.0:0.0;
                }
            }

            //buf[0]=0x01;

        } else {
            led1=led2=led3=led4=0.0;
            log("---------------------------------------------------------------loop end\r\n");
            return;
        }
    }
}



int getProtocol(int device);
void sendString(int device, int index, const char *str);

bool switchDevice(int device) {

    if (1==getProtocol(device)) {
        log("device supports protocol 1\r\n");

    } else {
        log("could not read device protocol version\r\n");
        return false;
    }


    sendString(device,ACCESSORY_STRING_MANUFACTURER,"Google, Inc.");
    sendString(device,ACCESSORY_STRING_MODEL,"DemoKit");
    sendString(device,ACCESSORY_STRING_DESCRIPTION,"DemoKit Arduino Board");
    sendString(device,ACCESSORY_STRING_VERSION,"1.0");
    sendString(device,ACCESSORY_STRING_URI,"http://www.android.com");
    sendString(device,ACCESSORY_STRING_SERIAL,"0000000012345678");


    USBControlTransfer(device,
                       HOST_TO_DEVICE|REQUEST_TYPE_VENDOR|RECIPIENT_DEVICE,
                       ACCESSORY_START,
                       0,//value
                       0, //index
                       0,
                       0,
                       0,
                       0 );
    return true;

}


int getProtocol(int device) {
    u16 data=-1;
    USBControlTransfer(device,
                       DEVICE_TO_HOST|REQUEST_TYPE_VENDOR|RECIPIENT_DEVICE,
                       ACCESSORY_GET_PROTOCOL,
                       0,//value
                       0, //index
                       (u8*)&data,
                       2,
                       0,
                       0 );
    //printf("return %d\r\n",data);
    return data;

}

void sendString(int device, int index, const char *str) {

    LOG("send_string start(%d,%d,%s)  %d \r\n",device,index,str,strlen(str)+1);

    //this is diffrent  google's sample but error ocard same sample
    USBControlTransfer(device,
                       DEVICE_TO_HOST /*HOST_TO_DEVIC use error why? please teach me*/|REQUEST_TYPE_VENDOR|RECIPIENT_DEVICE,
                       ACCESSORY_SEND_STRING,
                       0,//value
                       index,
                       (u8*)str,
                       strlen(str)+1
                      );

    LOG("send_string end(%d,%d,%s)\r\n",device,index,str);

}

//int  USBBulkTransfer(int device, int ep, u8* data, int length, USBCallback callback, void* userData)
int AdkUSB::read(u8 *buff, int len,  int nakLimit) {
    int ret=USBBulkTransfer(_device,input_ep|0x80,buff,len,0,0);
    log("adkUSB read -------                                                      xx %d \r\n",ret);
    return ret;
}
int AdkUSB::write(u8 *buff, int len) {
    log("adkUSB write -------                                                     xxx \r\n");
    return USBBulkTransfer(_device,output_ep,buff,len,0,0);
}


AdkUSB::AdkUSB(int device, int configuration, int interfaceNumber) {
    printf("connecting Android \r\n");
    _device = device;
    _configuration = configuration;
    _interfaceNumber = interfaceNumber;
    printf("device = %d configuration = %d interfaceNumber = %d\r\n", device, configuration, interfaceNumber);
    //int result;
    int err;
    //EndpointDescriptor* ep;

    u8 buffer[255];
    err = GetDescriptor(_device,DESCRIPTOR_TYPE_CONFIGURATION,0,buffer,4);

    if (err < 0) {
        log("Failed to get descriptor\r\n");
        return;
    }


    int len = buffer[2] | (buffer[3] << 8);
    if (len > sizeof(buffer)) {
        log("config descriptor too large\n");
        /* might want to truncate here */
        return;
    }
    err = GetDescriptor(_device,DESCRIPTOR_TYPE_CONFIGURATION,0,buffer,len);
    u8* p = buffer;
    input_ep=0;
    output_ep=0;
    EndpointDescriptor *epDesc;
    while (p<(buffer+len)) {
        u8 descLen  = p[0];
        u8 descType = p[1];
        log("descLen=%d,descType=%d\r\n",descLen,descType);
        switch (descType) {
            case DESCRIPTOR_TYPE_CONFIGURATION:
                log("config desc\r\n");
                break;
            case DESCRIPTOR_TYPE_INTERFACE:
                log("interface desc\r\n");
                break;
            case DESCRIPTOR_TYPE_ENDPOINT:
                epDesc=(EndpointDescriptor*)p;
                if (!input_ep && (epDesc->bEndpointAddress& 0x80)) {
                    input_ep=epDesc->bEndpointAddress& 0x7f;
                    //PacketSize drop
                    log("input Endpoint address=%d,wMaxPacketSize=%d,bmAttributes=%d\r\n",input_ep,epDesc->wMaxPacketSize,epDesc->bmAttributes);

                } else if (!output_ep) {
                    output_ep=epDesc->bEndpointAddress& 0x7f;
                    //PacketSize drop
                    log("output Endpoint address=%d,wMaxPacketSize=%d,bmAttributes=%d\r\n",input_ep,epDesc->wMaxPacketSize,epDesc->bmAttributes);
                } else {
                    //other
                    log("non input,output Endpoint address=%d,wMaxPacketSize=%d,bmAttributes=%d\r\n",input_ep,epDesc->wMaxPacketSize,epDesc->bmAttributes);
                }
                break;
            default:
                log("unkown desc type(%d) \r\n",descType);
        }
        p+=descLen;
    }

    if (!(input_ep && output_ep)) {
        log("can't find accessory endpoints\r\n");
        return;
    }

    err = SetConfiguration(device,configuration);
    if (err < 0) {
        log("SetConfiguration error\r\n");
        wait(10);
    }
}
