#include "mbed.h"

/* 

This is a game that tests your response speed 
In the terminal window type "b" to begin and as soon as the 
text "PRESS "s" NOW" is displayed, type "s" as quickly as possible.
The resultant response time will be shown in the terminal window.

Terminal settings are 9600, N, 8, 1.

By Abdul Kadir

*/

Serial pc(USBTX, USBRX); // tx, rx
Timer t;

int main() 
{
    int waittime;
    t.reset();
    printf("PRESS ""b"" to start or restart game anytime!\r\n");
    
    while(1)
    {
        char c = pc.getc();
        
        if(c == 'b')
        {
            waittime = rand() %6 + 2;       //get random number between 2 and 6
            wait((float)waittime);          //wait in seconds
            printf("PRESS ""s"" NOW!\r\n"); 
            t.start();                      //start timer
        }

        else if(c == 's')
        { 
            t.stop();
            printf("The response speed was %f seconds\r\n", t.read());
            t.reset();
            
        }
    }
    
}
