#include "mbed.h"
#include "wifi.h"
// Sensors drivers present in the BSP library
#include "stm32l475e_iot01_tsensor.h"
#include "stm32l475e_iot01_hsensor.h"
#include "VL53L0X.h"

#define WIFI_WRITE_TIMEOUT 10000
#define WIFI_READ_TIMEOUT  10000
#define CONNECTION_TRIAL_MAX          10

Serial pc(SERIAL_TX, SERIAL_RX);
uint8_t RemoteIP[] = {MBED_CONF_APP_SERVER_IP_1,MBED_CONF_APP_SERVER_IP_2,MBED_CONF_APP_SERVER_IP_3, MBED_CONF_APP_SERVER_IP_4};
uint8_t RxData [500];
char* modulename;
uint16_t RxLen;
uint8_t  MAC_Addr[6]; 
uint8_t  IP_Addr[4]; 
DigitalOut led(LED1);

static DevI2C devI2c(PB_11,PB_10);


static DigitalOut shutdown_pin(PC_6);
static VL53L0X range(&devI2c, &shutdown_pin, PC_7);


int main()
{
    int32_t Socket = -1;
    uint16_t Datalen;
    uint16_t Trials = CONNECTION_TRIAL_MAX;

    pc.baud(115200);
    
    /*Initialize  WIFI module */
    if(WIFI_Init() ==  WIFI_STATUS_OK) {
        printf("> WIFI Module Initialized.\n");  
        if(WIFI_GetMAC_Address(MAC_Addr) == WIFI_STATUS_OK) {
            printf("> es-wifi module MAC Address : %X:%X:%X:%X:%X:%X\n",     
                   MAC_Addr[0],
                   MAC_Addr[1],
                   MAC_Addr[2],
                   MAC_Addr[3],
                   MAC_Addr[4],
                   MAC_Addr[5]);   
        } else {
            printf("> ERROR : CANNOT get MAC address\n");
        }
    
        if( WIFI_Connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, WIFI_ECN_WPA2_PSK) == WIFI_STATUS_OK) {
            printf("> es-wifi module connected \n");
            if(WIFI_GetIP_Address(IP_Addr) == WIFI_STATUS_OK) {
                printf("> es-wifi module got IP Address : %d.%d.%d.%d\n",     
                       IP_Addr[0],
                       IP_Addr[1],
                       IP_Addr[2],
                       IP_Addr[3]); 
        
                printf("> Trying to connect to Server: %d.%d.%d.%d:27015 ...\n",     
                       RemoteIP[0],
                       RemoteIP[1],
                       RemoteIP[2],
                       RemoteIP[3]);
        
                while (Trials--){ 
                    if( WIFI_OpenClientConnection(0, WIFI_TCP_PROTOCOL, "TCP_CLIENT", RemoteIP, 27015, 0) == WIFI_STATUS_OK){
                        printf("> TCP Connection opened successfully.\n"); 
                        Socket = 0;
                    }
                }
                if(!Trials) {
                    printf("> ERROR : Cannot open Connection\n");
                }
            } else {
                printf("> ERROR : es-wifi module CANNOT get IP address\n");
            }
        } else {
            printf("> ERROR : es-wifi module NOT connected\n");
        }
    } else {
        printf("> ERROR : WIFI Module cannot be initialized.\n"); 
    }
    
    
    float sensor_valuet;
    float sensor_valueh;

    printf("Start sensor init\n");

    BSP_TSENSOR_Init();
    BSP_HSENSOR_Init();
    
    range.init_sensor(VL53L0X_DEFAULT_ADDRESS);

    int i = 0;
    
    while(1) {
        printf("\nNew loop, LED1 should blink during sensor read\n");

        led = 1;
        
        uint32_t distance;
        int status = range.get_distance(&distance);
        if (status == VL53L0X_ERROR_NONE) {
            printf("VL53L0X [mm]:            %6u\r\n", distance);
        } else {
            printf("VL53L0X [mm]:                --\r\n");
            distance = 0;
        }   
        
        int timer = 0;
        
        while (distance < 150 && distance > 0)
        {
            int status = range.get_distance(&distance);
            if (status == VL53L0X_ERROR_NONE) {
                printf("VL53L0X [mm]:            %6u\r\n", distance);
            } else {
                printf("VL53L0X [mm]:                --\r\n");
                distance = 0;
            } 
            
            timer++;
            i++;
            ThisThread::sleep_for(1000);
        }
        
        if (timer >= 10)
        {
            uint8_t data[1024] = "";
            uint8_t  temp[50] = "";
            
            sprintf((char *)temp, "%d", timer);
            strcat((char *)data, (char *)temp);
            
            if(Socket != -1) {
                if(WIFI_SendData(Socket, data, sizeof(data), &Datalen, WIFI_WRITE_TIMEOUT) != WIFI_STATUS_OK) {
                    printf("Desu\n");   
                }
            }  
        }  
        
        if (i%60 == 0)
        {
            uint8_t data[1024] = "";
            uint8_t  temp[50] = "";
            sensor_valuet = BSP_TSENSOR_ReadTemp();
            sensor_valueh = BSP_HSENSOR_ReadHumidity();
            printf("\nTEMPERATURE = %.2f degC\n", sensor_valuet);
            printf("HUMIDITY    = %.2f %%\n", sensor_valueh);
        
        
            sprintf((char *)temp, "%f", sensor_valuet);
            strcat((char *)data, (char *)temp);
            strcat((char *)data, (char *)",");
            sprintf((char *)temp, "%f", sensor_valueh);
            strcat((char *)data, (char *)temp);
        
            printf("%s\n", data);
        
            if(Socket != -1) {
                if(WIFI_SendData(Socket, data, sizeof(data), &Datalen, WIFI_WRITE_TIMEOUT) != WIFI_STATUS_OK) {
                    printf("Desu\n");   
                }
            }  
        }

        led = 0;
        
        ThisThread::sleep_for(1000);
        i++;

    }
}
