#include "mbed.h"
#include "HX711.h"
#include "TextLCD.h"

#define BLINKING_RATE  0.5
#define temps_on 0.5

// LCD and Joystick Setting
TextLCD lcd(p8, p10, p11, p5, p6, p7); // rs, e, d4-d7
         //rs   e    d4  d5   d6    d7          

DigitalOut RW(p9);

//LED MBED
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//LED BICOLORE
//DigitalOut ledB1(p29); // SI 1 LED ROUGE
//DigitalOut ledB2(p30); // SI 1 LED VERT
DigitalOut myledR(p30); // LED Rouge
DigitalOut myledV(p29); // LED Vert

//HX711
HX711 scale1(p22, p21); //22 , 21
HX711 scale2(p24, p23); //24 , 23

// BOUTON
DigitalIn Up(p12);
DigitalIn Down(p13);
DigitalIn Left(p14);
DigitalIn Right(p15);
DigitalIn Center(p16);

int MOI  = 0; // en kg*cm2
int f0  = 256 ; // en g
int f1 = 657 ;  // en g
int m = 0 ; // en g
int l1 = 45 ; // en cm
int lg = 0 ; // en cm
int menu = 0;
int tempo_saisie = 130 ;


float calibration_factor1 = 2325; //2325 // -7050 worked for my 440lb max scale setup
float calibration_factor2 = 2178; //2178
int averageSamples = 5; //NOMBRE DE MESURE
float weight1 = 0; // F1
float weight2 = 0; // F0


int main(void) {
    
      
        RW = 0;
       menu = 0 ;

      scale1.setScale(0);
      scale1.tare(); //Reset the scale to 0

      scale2.setScale(0);
      scale2.tare(); //Reset the scale to 0
  
      scale1.setScale(calibration_factor1); //Adjust to this calibration factor / Ajuster à ce facteur d'étalonnage
      scale2.setScale(calibration_factor2); //Adjust to this calibration factor / Ajuster à ce facteur d'étalonnage
      
      
       lcd.locate(0,0); 
       lcd.printf("   mesure MOI     ");
       lcd.locate(0,1); 
       lcd.printf("  club de golf    ");
       wait_ms(2000);
       lcd.cls(); 
       
      
      while(1)
      {
      weight1 = scale1.getGram();
      weight2 = scale2.getGram();
      
       f0 = (int) weight1 ;
      f1 = (int) weight2 ; 
      
      
          m = f1 - f0 ;
        lg = (l1*f1)/(f1-f0);
        MOI = m*lg*lg/1000 ;
 
 switch(menu)
{
      
    case(0):
           
           lcd.locate(1,0); 
           lcd.printf("*Mesures Forces");
           lcd.locate(1,1); 
           lcd.printf(" Calcul MOI    ");
           wait_ms(tempo_saisie);
           
      if (!Center ){
           lcd.cls(); 
           menu = 3 ;
           }  
     
      if (!Down){
           lcd.cls();
           menu = 1 ;}
           
      if (!Right ){
           lcd.cls(); 
           menu = 7 ;
           } 
           
        myledV = 0;
        myledR = 0;   
           
           
           break; //fin case 0
                 
    
    case(1):
           
     
          
           lcd.locate(1,0); 
           lcd.printf(" Mesures Forces");
           lcd.locate(1,1); 
           lcd.printf("*Calcul MOI    ");
           wait_ms(tempo_saisie);
         
      if (!Center ){
           lcd.cls(); 
           menu = 4 ;
           }  
     
      if (!Down){
           lcd.cls();
           menu = 2 ;}
           
      if (!Up){
           lcd.cls();
           menu = 0 ;}
           
      if (!Right ){
           lcd.cls(); 
           menu = 7 ;
           } 
        myledV = 0;
        myledR = 0;    
           
           
           break; //fin case 1 
                 
         
    case (2):
           
           lcd.locate(1,0);
           lcd.printf(" Calcul MOI    ");
           lcd.locate(1,1); 
           lcd.printf("*Masse/longueur");
           wait_ms(tempo_saisie);
        
       if (!Center ){
           lcd.cls(); 
           menu = 5 ;
           }  
             
       if (!Up){
           lcd.cls();
           menu = 1 ;}
           
       if (!Right ){
           lcd.cls(); 
           menu = 7 ;
           } 
           
                         
        myledV = 0;
        myledR = 0;
           
           break; //fin case 2 
           
    case (3):
           
           lcd.locate(1,0);
           lcd.printf("F0 =  %d g", f0);
           lcd.locate(1,1);
           lcd.printf("F1 =  %d g", f1);
           wait_ms(tempo_saisie);
           
       if (!Left ){
           lcd.cls(); 
           menu = 0 ;
           }
           
        myledV = 1;
        wait(0.2);
        myledV = 0;
        wait(0.2);
        myledR = 0;
        

           break; //fin case 3  
           
    case (4):
 
           lcd.locate(0,0);
           lcd.printf("MOI= %d kg*cm2", MOI);
           wait_ms(tempo_saisie);
           
       if (!Left ){
           lcd.cls(); 
           menu = 1 ;
           }             
           
        myledR = 1;
        wait(0.2);
        myledR = 0;
        wait(0.2);
        myledV = 0;
        
           
           break; //fin case 4 
               
    case (5):
         
           lcd.locate(1,0);
           lcd.printf(" Masse = %d g" , m);
           wait_ms(tempo_saisie);
           
       if (!Left ){
           lcd.cls(); 
           menu = 2 ;
           }  
           
       if (!Right ){
           lcd.cls(); 
           menu = 6 ;
           } 
           
                 
        myledV = 1;
        myledR = 0;
           
           
           break; //fin case 5 
           
    
    case (6):
          
           lcd.locate(1,0);
           lcd.printf(" l1 = %d cm" , l1);
           lcd.locate(1,1);
           lcd.printf(" lg = %d cm" , lg);
           wait_ms(tempo_saisie);
           
       if (!Left ){
           lcd.cls(); 
           menu = 2 ;
           }  
        
        myledR = 1;
        myledV = 0;
        
           
           break; //fin case 6 
       
       
    case (7):
        
         
           lcd.locate(1,0);
           lcd.printf(" HTML      ");
           wait_ms(tempo_saisie);
           
       if (!Left ){
           lcd.cls(); 
           menu = 0 ;
           }  
           
        myledR = 1;
        wait(0.2);
        myledV = 0;
        wait(0.2);
        
        myledR = 0;
        wait(0.2);
        myledV = 1;
        wait(0.2);
        
           break; //fin case 7   
                             
    } } }