#include "mbed.h"
#include "ESP8266.h"                            //Include header file from Author: Antonio Quevedo
#include "hcsr04.h"

#define APIKEY E21WSWLRUWTIDWNX                 //Put "Write key" of your channel in thingspeak.com 
#define IP "184.106.153.149"                    //IP Address of "api.thingspeak.com\"
#define WIFI_SSID "some-ssid"
#define WIFI_PASS "some-passwd"

Serial pc(USBTX,USBRX);
ESP8266 esp(D1, D0, 115200);                    //baud rate for wifi
HCSR04  usensor(A4, A5);                        //Trigger, Echo

char snd[255],rcv[1000],snd_Data[255];          //snd= string used to send command to ESP 8266 wii and  rcv = string used to receive response from ESP8266 wifi module 

void esp_initialize(void);                      //Function used to initialize ESP8266 wifi module 
void esp_send(char);                            //Function used to connect with thingspeak.com and update channel using ESP8266 wifi module 

int ping()
{
    usensor.start();
    wait_ms(500);
    return(usensor.get_dist_cm());
}

int main() 
{    
    pc.baud(115200);                            //Baud rate used for communicating with Tera-term on PC
    
    pc.printf("START\r\n");                     //Starting point
    esp_initialize();
    
    int distance;
    char cd;

    while (1) 
    {   
        distance = ping();                      //ping function
        pc.printf("\n distance = %ld cm",distance);
        wait_ms(10000);
        if(distance<=30)
        {
            cd = 'd';
            esp_send(cd);
        }
        else
        {
            cd = 'a';
            esp_send(cd);
        }
    }
}

void esp_initialize(void)
{    
    pc.printf("Initializing ESP\r\n"); 
      
    pc.printf("Reset ESP\r\n"); 
    esp.Reset();                                //RESET ESP
    esp.RcvReply(rcv, 400);                     //receive a response from ESP
    //pc.printf(rcv);                           //Print the response onscreen 
    wait(2);
    
    strcpy(snd,"AT");
    esp.SendCMD(snd);
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       
    pc.printf(rcv);      
    wait(0.1);
    
    strcpy(snd,"AT+CWMODE=1");
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(2);

    strcpy(snd,"AT+CWJAP=\"");
    strcat(snd,WIFI_SSID);
    strcat(snd,"\",\"");
    strcat(snd,WIFI_PASS);
    strcat(snd,"\"");
    
    esp.SendCMD(snd);
    pc.printf(snd);
    wait(5);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 
    
    strcpy(snd,"AT+CIPMUX=0");
    esp.SendCMD(snd);
    pc.printf(snd);
    //wait(2);
    esp.RcvReply(rcv, 400);       
    pc.printf("\n %s \n", rcv); 
}

void esp_send(char ch)
{
    //ESP updates the Status of Thingspeak channel//
    strcpy(snd,"AT+CIPSTART=");
    strcat(snd,"\"TCP\",\"");
    strcat(snd,IP);
    strcat(snd,"\",80");
    
    esp.SendCMD(snd); 
    pc.printf("S\r\n%s",snd);
    //wait(2);                                                    
    esp.RcvReply(rcv, 1000);
    pc.printf("R\r\n%s",rcv);
    wait(1);
    
    sprintf(snd,"GET https://api.thingspeak.com/update?api_key=E21WSWLRUWTIDWNX&field1=%c\n",ch);
    
    int i=0;
    for(i=0;snd[i]!='\0';i++);
    i++;
    char cmd[255];
    
    sprintf(cmd,"AT+CIPSEND=%d",i);             //Send Number of open connection and Characters to send 
    esp.SendCMD(cmd);
    pc.printf("S\r\n%s",cmd);
    while(i<=20 || rcv == ">")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("R\r\n%s",rcv);
    esp.SendCMD(snd);                           //Post value to thingspeak channel
    pc.printf("S\r\n%s",snd);
    while(i<=20 || rcv == "OK")
    {
        esp.RcvReply(rcv, 1000);
        wait(100);
        i++;
    }
    pc.printf("R\r\n%s",rcv);
}