#include "mbed.h"

/*******************************************************************************
* Module:     BUSI2C.cpp
* Function:   Controleur de bus I2C por un driver de glcd128x128
* Author:     Belloula AbdelMalek [31.10.2010]
*******************************************************************************/
#include "mbed.h"

I2C i2c(p9, p10); // sda, scl
//char RD_CMD = 0xF9;
//char WR_CMD = 0xFA;
//char RD_DATA = 0xF1;
//char WR_DATA = 0xF7;
//char SET = 0xFF;
//char RESET = 0xEF;

unsigned int adress_PCFcmd = 0x40;
unsigned int adress_PCFdata = 0x42;

char cmd[10]={0xF7,0xFA,0xF9,0xF1,0xF2,0xFF,0xEF};
char data[5];

Serial pc(USBTX, USBRX); // tx, rx


void reset_lcd_chip(void) /* reset the LCD controller chip */
    {       
        i2c.write(adress_PCFcmd,cmd+6, 1); // cmd [1] = 0xEF
        wait(0.05);
       	i2c.write(adress_PCFdata,cmd+5, 1);    // cmd [0] = 0xFF
    }

void lcd_busy_wait(void)// status check
 {       
    do
    {
        i2c.write(adress_PCFcmd,cmd+2, 1);  // cmd [2] = 0xF9
        i2c.read(adress_PCFdata,data, 1);   // data 
        i2c.write(adress_PCFcmd,cmd+5, 1);  // cmd [0] = 0xFF
    }
    while((data[0] & 0x03) != 0x03);        /* wait till STA1=1 && STA0=1 */
    
 }

 void  write_data_byte (void) // Procedure for sending a data
    {
        lcd_busy_wait(); 		                // status check
        i2c.write(adress_PCFcmd,cmd, 1);        // cmd [2] = 0xF7
        i2c. write (adress_PCFdata,data, 1);    // data 
        i2c.write(adress_PCFcmd,cmd+4, 1);      // cmd [2] = 0xF2
        i2c.write(adress_PCFcmd,cmd, 1);        // cmd [2] = 0xF7
        i2c.write(adress_PCFcmd,cmd+5, 1);      // cmd [2] = 0xFF
    }

 void  write_cmd_byte (void) // Procedure for sending a command;
    {
        lcd_busy_wait(); // status check
        i2c. write (adress_PCFdata,data, 1);   //data  (commande)
        i2c.write(adress_PCFcmd,cmd+4, 1);  // cmd [x] = 0xF2
        i2c.write(adress_PCFcmd,cmd, 1);  // cmd [x] = 0xF7
        i2c.write(adress_PCFcmd,cmd+5, 1);  // cmd [x] = 0xFF
    }



int main() 
{
    int count = 0;
    //Scan for I2C slave devices (0 => no slave found !0 => address of the slaved device found )
    printf("I2CU! Searching for I2C devices...\n");
    for (int address=0; address<256; address+=2)   
    {
        if (!i2c.write(address, NULL, 0)) 
            { // 0 returned is ok
                printf(" - I2C device found at address 0x%02X\n", address);
                count++;
            }
    }
    printf("%d devices found\n", count);
    
    reset_lcd_chip();
    
    lcd_busy_wait();
    data[0]= 0x00;
    write_data_byte();
   
    lcd_busy_wait();
    data[0]= 0x00;
    write_data_byte();
    
    lcd_busy_wait();
    data[0]= 0x42;
    write_cmd_byte();
    
    lcd_busy_wait();
    data[0]= 0x00;
    write_data_byte();
   
    lcd_busy_wait();
    data[0]= 0x10;
    write_data_byte();
    
    lcd_busy_wait();
    data[0]= 0x43;
    write_cmd_byte();
    
    
    lcd_busy_wait();
    data[0]= 0x98;
    write_cmd_byte();
    
    lcd_busy_wait();
    data[0]= 0x00;
    write_data_byte();
   
    lcd_busy_wait();
    data[0]= 0x00;
    write_data_byte();
    
    lcd_busy_wait();
    data[0]= 0x24;
    write_cmd_byte();
    
   /*
    data_write
    i2c.write(adress_PCF8574,cmd[4], 1);/0xF7
    i2c.writ(adress_PCF8574+2,data, 1);
    i2c.write(adress_PCF8574,cmd[4]& 0xF2, 1);
    i2c.write(adress_PCF8574,cmd[4]& 0xF7, 1);
    i2c.write(adress_PCF8574,cmd[0], 1);
   
    */
   
  

}

