/*
Copyright (c) 2010 Peter Barrett

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

/* 
Tue Apr 26 2011 Bart Janssens: added PS3 USB support
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <mbed.h>

#include "USBHost.h"
#include "Utils.h"
#include "ps3.h"

#define AUTOEVT(_class,_subclass,_protocol) (((_class) << 16) | ((_subclass) << 8) | _protocol)
#define AUTO_KEYBOARD AUTOEVT(CLASS_HID,1,1)
#define AUTO_MOUSE AUTOEVT(CLASS_HID,1,2)
//#define AUTO_PS3 AUTOEVT(CLASS_HID,0,0)

u8 auto_mouse[4];       // buttons,dx,dy,scroll
u8 auto_keyboard[8];    // modifiers,reserved,keycode1..keycode6
u8 auto_joystick[4];    // x,y,buttons,throttle
//u8 auto_ps3[48];




void AutoEventCallback(int device, int endpoint, int status, u8* data, int len, void* userData)
{
    int evt = (int)userData;
    switch (evt)
    {
        case AUTO_KEYBOARD:
            printf("AUTO_KEYBOARD ");
            break;
        case AUTO_MOUSE:
            printf("AUTO_MOUSE ");
            break;
//        case AUTO_PS3:
//            printf("AUTO_PS3 "); 
//            ParsePs3Report(data,len);
//            break;      
        default:
            printf("HUH ");
    }
    //printfBytes("data",data,len);
    USBInterruptTransfer(device,endpoint,data,len,AutoEventCallback,userData);
}

//  Establish transfers for interrupt events
void AddAutoEvent(int device, InterfaceDescriptor* id, EndpointDescriptor* ed)
{
    printf("message from endpoint %02X\r\n",ed->bEndpointAddress);
    printf("Class Sub Proto: %02X %02X %02X\r\n",id->bInterfaceClass,id->bInterfaceSubClass,id->bInterfaceProtocol);
    //if ((ed->bmAttributes & 3) != ENDPOINT_INTERRUPT || !(ed->bEndpointAddress & 0x80))
    //    return;
    
    // Make automatic interrupt enpoints for known devices
    u32 evt = AUTOEVT(id->bInterfaceClass,id->bInterfaceSubClass,id->bInterfaceProtocol);
    printf("Evt: %08X \r\n",evt);
    u8* dst = 0;
    int len;
    switch (evt)
    {
        case AUTO_MOUSE:
            dst = auto_mouse;
            len = sizeof(auto_mouse);
            break;
        case AUTO_KEYBOARD:
            dst = auto_keyboard;
            len = sizeof(auto_keyboard);
            break;
//        case AUTO_PS3:
//            printf("PS3 event ? \r\n");
//            dst = auto_ps3;
//            len = sizeof(auto_ps3);
        default:
            printf("Interrupt endpoint %02X %08X\r\n",ed->bEndpointAddress,evt);
            break;
    }
    if (dst)
    {
        printf("Auto Event for %02X %08X\r\n",ed->bEndpointAddress,evt);
        USBInterruptTransfer(device,ed->bEndpointAddress,dst,len,AutoEventCallback,(void*)evt);
    }
}

void PrintString(int device, int i)
{
    u8 buffer[256];
    int le = GetDescriptor(device,DESCRIPTOR_TYPE_STRING,i,buffer,255);
    if (le < 0)
         return;
    char* dst = (char*)buffer;
    for (int j = 2; j < le; j += 2)
        *dst++ = buffer[j];
    *dst = 0;
    printf("%d:%s\r\n",i,(const char*)buffer);
 }
 
//  Walk descriptors and create endpoints for a given device
int StartAutoEvent(int device, int configuration, int interfaceNumber)
{

    printf("StartAutoEvent \r\n");

    u8 buffer[255];
    int err = GetDescriptor(device,DESCRIPTOR_TYPE_CONFIGURATION,0,buffer,255);
    if (err < 0)
        return err;

    int len = buffer[2] | (buffer[3] << 8);
    u8* d = buffer;
    u8* end = d + len;
    while (d < end)
    {
        if (d[1] == DESCRIPTOR_TYPE_INTERFACE)
        {
            InterfaceDescriptor* id = (InterfaceDescriptor*)d;
            if (id->bInterfaceNumber == interfaceNumber)
            {
                 d += d[0];
                while (d < end && d[1] != DESCRIPTOR_TYPE_INTERFACE)
                {
                    if (d[1] == DESCRIPTOR_TYPE_ENDPOINT)
                       AddAutoEvent(device,id,(EndpointDescriptor*)d);
                    d += d[0];
                }
            }
        }
        d += d[0];
    }
    return 0;
}

/*
int StartPS3Event(int device, int configuration, int interfaceNumber)
{

    printf("StartPS3Event \r\n");
    
    EndpointDescriptor* ep;
    
    u8 buf[4];
    buf[0] = 0x42;
    buf[1] = 0x0c;
    buf[2] = 0x00;
    buf[3] = 0x00;
    
    u8 buf2[8];
    u8 buf3[8];
    
    buf2[0] = 0x01;
    buf2[1] = 0x00;
    buf2[2] = 0x00;
    buf2[3] = 0x02;
    buf2[4] = 0x72;
    buf2[5] = 0xAD;
    buf2[6] = 0xF3;
    buf2[7] = 0x5B;
    
    
    
    
    int result;
    int err;
                
    u8 buffer[255];
    err = GetDescriptor(device,DESCRIPTOR_TYPE_CONFIGURATION,0,buffer,255);
    if (err < 0)
        return err;
    
    
    
    //configure the device
    //err = USBControlTransfer(device, HOST_TO_DEVICE|REQUEST_TYPE_STANDARD|RECIPIENT_DEVICE, SET_CONFIGURATION, 1, 0, 0, 0, 0, 0 );
    err = SetConfiguration(device,1);
    printf("set config result = %d\r\n", err);
    
    // get Mac address    
    //err = USBControlTransfer(device, HOST_TO_DEVICE|REQUEST_TYPE_CLASS|RECIPIENT_DEVICE, HID_REQUEST_GET_REPORT, 0x03f5, 0, buf3, sizeof(buf3), 0, 0 );
    //printf("get Mac to %02X:%02X:%02X:%02X:%02X:%02X , result = %d\r\n", buf3[2], buf3[3], buf3[4], buf3[5], buf3[6], buf3[7], err);
    
    // set Mac address    
    err = USBControlTransfer(device, HOST_TO_DEVICE|REQUEST_TYPE_CLASS|RECIPIENT_INTERFACE, HID_REQUEST_SET_REPORT, 0x03f5, 0, buf2, sizeof(buf2), 0, 0 );
    printf("set Mac to %02X:%02X:%02X:%02X:%02X:%02X , result = %d\r\n", buf2[2], buf2[3], buf2[4], buf2[5], buf2[6], buf2[7], err);
    
    // get Mac address    
    //err = USBControlTransfer(device, HOST_TO_DEVICE|REQUEST_TYPE_CLASS|RECIPIENT_DEVICE, HID_REQUEST_GET_REPORT, 0x03f5, 0, buf3, sizeof(buf3), 0, 0 );
    //printf("get Mac to %02X:%02X:%02X:%02X:%02X:%02X , result = %d\r\n", buf3[2], buf3[3], buf3[4], buf3[5], buf3[6], buf3[7], err);

    err = USBControlTransfer(device, HOST_TO_DEVICE|REQUEST_TYPE_CLASS|RECIPIENT_INTERFACE, HID_REQUEST_SET_REPORT, 0x03f4,0, buf, sizeof(buf), 0, 0 );
    printf("set report result = %d\r\n", err);
    //USBTransfer(device,0,DEVICE_TO_HOST,buf,sizeof(buf),0,0);

    int len = buffer[2] | (buffer[3] << 8);
    u8* d = buffer;
    u8* end = d + len;
    while (d < end)
    {
        if (d[1] == DESCRIPTOR_TYPE_INTERFACE)
        {
            InterfaceDescriptor* id = (InterfaceDescriptor*)d;
            if (id->bInterfaceNumber == interfaceNumber)
            {
                 d += d[0];
                while (d < end && d[1] != DESCRIPTOR_TYPE_INTERFACE)
                {
                    if (d[1] == DESCRIPTOR_TYPE_ENDPOINT)
                        ep = (EndpointDescriptor*)d;
                        
                        if (ep->bEndpointAddress == 0x02)  {
                            printf("PS3 input endpoint (0x02) found\r\n");
                            
                        }
                        if (ep->bEndpointAddress == 0x81)  {
                            printf("PS3 output endpoint (0x81) found\r\n");
                            AddAutoEvent(device,id,(EndpointDescriptor*)d);
                        }
                    d += d[0];
                }
            }
        }
        d += d[0];
    }
    return 0;
}
*/

//  Implemented in main.cpp
int OnDiskInsert(int device);

//  Implemented in TestShell.cpp
int OnBluetoothInsert(int device);
void convert(u8 *mac){
    LocalFileSystem local("local"); 
    FILE *fp;
    fp = fopen("/local/data.p3b", "r");
    if(fp==NULL){
        fp = fopen("/local/data.p3b", "w");
        fprintf(fp,"00:02:72:D0:82:F7");
        fclose(fp);
        fp = fopen("/local/data.p3b", "r");
    }
    char a[20];
    fgets(a,sizeof(a),fp);
    char b[6][5];
    char *end;
    for(int i=0;i<6;i++){
        b[i][0]='0';
        b[i][1]='x';
        b[i][2]=a[i*3];
        b[i][3]=a[1+i*3];
        b[i][4]='\n';
        mac[i]=(u8)strtol(b[i],&end,0);
    }
    fclose(fp);
}
    

void OnLoadDevice(int device, DeviceDescriptor* deviceDesc, InterfaceDescriptor* interfaceDesc)
{
    printf("LoadDevice %d %02X:%02X:%02X\r\n",device,interfaceDesc->bInterfaceClass,interfaceDesc->bInterfaceSubClass,interfaceDesc->bInterfaceProtocol);
    char s[128];
    //u8 my_mac[6] = {0x00, 0x02, 0x72, 0xD0, 0x82, 0xF7}; // mac address of my Bluetooth device
    u8 my_mac[6];
    convert(my_mac);
    
    u8 buf2[6];
    
    buf2[0] = 0x00;
    buf2[1] = 0x02;
    buf2[2] = 0x72;
    buf2[3] = 0xAD;
    buf2[4] = 0xF3;
    buf2[5] = 0x5B;
    
    
    for (int i = 1; i < 3; i++)
    {
        if (GetString(device,i,s,sizeof(s)) < 0)
            break;
        printf("%d: %s\r\n",i,s);
    }
    
    switch (interfaceDesc->bInterfaceClass)
    {
        case CLASS_MASS_STORAGE:
            if (interfaceDesc->bInterfaceSubClass == 0x06 && interfaceDesc->bInterfaceProtocol == 0x50)
                OnDiskInsert(device);    // it's SCSI!
            break;
        case CLASS_WIRELESS_CONTROLLER:
            if (interfaceDesc->bInterfaceSubClass == 0x01 && interfaceDesc->bInterfaceProtocol == 0x01)
                OnBluetoothInsert(device);    // it's bluetooth!
            break;
        case CLASS_HID:
            //追加部分
            /*if (interfaceDesc->bInterfaceSubClass == 0x01 && interfaceDesc->bInterfaceProtocol == 0x01)
                OnBluetoothInsert(device);    // it's bluetooth!
            break;
            *///追加部分ここまで
            printf("idVendor = %04X idProduct = %04X \r\n",deviceDesc->idVendor,deviceDesc->idProduct);
            //printf("device = %d configuration = %d interfaceNumber = %d\r\n", device, configuration, interfaceNumber);
            //if (deviceDesc->idVendor == 0x054C &&  deviceDesc->idProduct == 0x0268) StartPS3Event(device,1,0);
            if (deviceDesc->idVendor == 0x054C &&  deviceDesc->idProduct == 0x0268) {
                Ps3USB _Ps3USB(device,1,0);
                     
                _Ps3USB.SetPair(my_mac);
                _Ps3USB.Enable();
                _Ps3USB.Led(1);
                _Ps3USB.Rumble(0x20,0xff,0x20,0xff);
                _Ps3USB.ShowPair();
                
            }
            else StartAutoEvent(device,1,0);
            break;
        default:
            printf("Not yet supported \r\n");
            //StartAutoEvent(device,1,0);
            break;
    }
}