#include "ADXL345.h"
#include "mbed.h"
#include "iostream"
#include "stdio.h"
#include "stdlib.h"
#include "string"

using namespace std;

PortOut ledport(Port1, 0xFFFFFFFF);
ADXL345 accelerometer(p5, p6, p7, p8);
//Serial pc(USBTX, USBRX);
//---shiftbrite
DigitalOut latch(p15);
DigitalOut enable(p16);
SPI spi(p11, p12, p13);

DigitalOut led8(p28);
DigitalOut led7(p27);
DigitalOut led6(p26);
DigitalOut led5(p25);
DigitalOut led4(p24);
DigitalOut led3(p23);
DigitalOut led2(p22);
DigitalOut led1(p21);

// ------------------------- Zigbee -------------

Serial xbee2(p9, p10);
DigitalOut rst1(p17);
Serial pc1(USBTX, USBRX);
DigitalOut myled(LED2);

//----RGB Led function

void RGB_LED(int red, int green, int blue)
{
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}

int main()
{
    int count=0;
    int readings[3] = {0, 0, 0};
    //int del = 0;
    int16_t sum = 0;
    int16_t xval[50];
    int i = 0;
    char text[30];
    int len,len1;
    len1 = 0;
    len = 0;

    //---------SHift brite

    int red=0;
    int green=0;
    int blue=0;
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;

    // --------- Zigbee

    char character;
    rst1 = 0;   //Set reset pin to 0
    myled = 0;
    wait_ms(1);
    rst1 = 1;   //Set reset pin to 1
    wait_ms(1);

    char buffer[20];
    int global = 0;

//--- Zigbeeee

    const char font[0x60][5] = {

        {0x00,0x00,0x00,0x00,0x00},     // ASCII -  32 space
        {0x00,0x00,0xF9,0x00,0x00},     // ASCII -  33 !
        {0x00,0xE0,0x00,0xE0,0x00},     // ASCII -  34 "
        {0x24,0x7E,0x24,0x7E,0x24},     // ASCII -  35 #
        {0x34,0x4A,0xFF,0x49,0x26},     // ASCII -  36 $
        {0x22,0x04,0x08,0x10,0x22},     // ASCII -  37 %
        {0x26,0x59,0x4D,0x52,0x25},     // ASCII -  38 &
        {0x00,0x00,0xE0,0x00,0x00},     // ASCII -  39 '
        {0x00,0x3C,0x42,0x81,0x00},     // ASCII -  40 (
        {0x00,0x81,0x42,0x3C,0x00},     // ASCII -  41 )
        {0x28,0x30,0xE0,0x30,0x28},     // ASCII -  42 *
        {0x08,0x08,0x3E,0x08,0x08},     // ASCII -  43 +
        {0x00,0x01,0x02,0x00,0x00},     // ASCII -  44 ,
        {0x08,0x08,0x08,0x08,0x08},     // ASCII -  45 -
        {0x00,0x00,0x01,0x00,0x00},     // ASCII -  46 .
        {0x02,0x04,0x08,0x10,0x20},     // ASCII -  47 /
        {0x7E,0x81,0x81,0x81,0x7E},     // ASCII -  48 0
        {0x00,0x21,0xFF,0x01,0x00},     // ASCII -  49 1
        {0x41,0x83,0x85,0x89,0x71},     // ASCII -  50 2
        {0x42,0x91,0x91,0x91,0x6E},     // ASCII -  51 3
        {0xF0,0x10,0x10,0x10,0xFF},     // ASCII -  52 4
        {0xF2,0x91,0x91,0x91,0x8E},     // ASCII -  53 5
        {0x3E,0x51,0x91,0x91,0x8E},     // ASCII -  54 6
        {0x87,0x88,0x90,0xA0,0xC0},     // ASCII -  55 7
        {0x76,0x89,0x89,0x89,0x76},     // ASCII -  56 8
        {0x62,0x91,0x91,0x91,0x7e},     // ASCII -  57 9
        {0x00,0x00,0x24,0x00,0x00},     // ASCII -  58 :
        {0x00,0x01,0x12,0x00,0x00},     // ASCII -  59 ;
        {0x00,0x08,0x14,0x22,0x41},     // ASCII -  60 <
        {0x14,0x14,0x14,0x14,0x14},     // ASCII -  61 =
        {0x00,0x41,0x22,0x14,0x08},     // ASCII -  62 >
        {0x40,0x80,0x8D,0x90,0x60},     // ASCII -  63 ?
        {0x7E,0x81,0xBD,0xA5,0x78},     // ASCII -  64 @
        {0x3F,0x48,0x88,0x48,0x3F},     // ASCII -  65 A
        {0xFF,0x91,0x91,0x99,0x66},     // ASCII -  66 B
        {0x3C,0x42,0x81,0x81,0x42},     // ASCII -  67 C
        {0xFF,0x81,0x81,0x42,0x3C},     // ASCII -  68 D
        {0xFF,0x91,0x91,0x91,0x81},     // ASCII -  69 E
        {0xFF,0x90,0x90,0x90,0x80},     // ASCII -  70 F
        {0x3E,0x41,0x8F,0x88,0x4F},     // ASCII -  71 G
        {0xFF,0x10,0x10,0x10,0xFF},     // ASCII -  72 H
        {0x00,0x81,0xFF,0x81,0x00},     // ASCII -  73 I
        {0x06,0x01,0x81,0xFE,0x80},     // ASCII -  74 J
        {0xFF,0x18,0x24,0x42,0x81},     // ASCII -  75 K
        {0xFF,0x01,0x01,0x01,0x01},     // ASCII -  76 L
        {0xFF,0x40,0x30,0x40,0xFF},     // ASCII -  77 M
        {0xFF,0x40,0x20,0x10,0xFF},     // ASCII -  78 N
        {0x7E,0x81,0x81,0x81,0x7E},     // ASCII -  79 O
        {0xFF,0x90,0x90,0x90,0x60},     // ASCII -  80 P
        {0x7E,0x81,0x85,0x82,0x7D},     // ASCII -  81 Q
        {0xFF,0x98,0x94,0x92,0x61},     // ASCII -  82 R
        {0x72,0x89,0x89,0x89,0x46},     // ASCII -  83 S
        {0x80,0x80,0xFF,0x80,0x80},     // ASCII -  84 T
        {0xFE,0x01,0x01,0x01,0xFE},     // ASCII -  85 U
        {0xFC,0x02,0x01,0x02,0xFC},     // ASCII -  86 V
        {0xFF,0x02,0x1C,0x02,0xFF},     // ASCII -  87 W
        {0xC3,0x24,0x18,0x24,0xC3},     // ASCII -  88 X
        {0xC0,0x20,0x1F,0x20,0xC0},     // ASCII -  89 Y
        {0x87,0x89,0x91,0xA1,0xC1},     // ASCII -  90 Z
        {0x00,0xFF,0x81,0x81,0x00},     // ASCII -  91 [
        {0x20,0x10,0x08,0x04,0x02},     // ASCII -  92 '\'
        {0x00,0x81,0x81,0xFF,0x00},     // ASCII -  93 ]
        {0x20,0x40,0x80,0x40,0x20},     // ASCII -  94 ^
        {0x01,0x01,0x01,0x01,0x01},     // ASCII -  95 _
        {0x00,0x80,0x40,0x20,0x00},     // ASCII -  96 `
        {0x26,0x29,0x29,0x1F,0x01},     // ASCII -  97 a
        {0xFF,0x11,0x11,0x11,0x0E},     // ASCII -  98 b
        {0x0E,0x11,0x11,0x11,0x11},     // ASCII -  99 c
        {0x0E,0x11,0x11,0x11,0xFF},     // ASCII - 500 d
        {0x0E,0x15,0x15,0x15,0x0D},     // ASCII - 101 e
        {0x10,0x10,0x7F,0x90,0x90},     // ASCII - 102 f
        {0x08,0x15,0x15,0x15,0x0E},     // ASCII - 103 g
        {0xFF,0x08,0x08,0x08,0x07},     // ASCII - 104 h
        {0x00,0x00,0x9F,0x00,0x00},     // ASCII - 105 i
        {0x02,0x01,0x01,0x9F,0x00},     // ASCII - 106 j
        {0xFF,0x04,0x0A,0x11,0x00},     // ASCII - 107 k
        {0x00,0x01,0xFF,0x01,0x00},     // ASCII - 108 l
        {0x1F,0x10,0x0F,0x10,0x0F},     // ASCII - 109 m
        {0x10,0x0F,0x10,0x10,0x0F},     // ASCII - 110 n
        {0x0E,0x11,0x11,0x11,0x0E},     // ASCII - 111 o
        {0x1F,0x14,0x14,0x14,0x08},     // ASCII - 112 p
        {0x08,0x14,0x14,0x14,0x1F},     // ASCII - 113 q
        {0x1F,0x08,0x10,0x10,0x08},     // ASCII - 114 r
        {0x09,0x15,0x15,0x15,0x12},     // ASCII - 115 s
        {0x10,0x10,0x7F,0x11,0x12},     // ASCII - 116 t
        {0x1F,0x01,0x01,0x1F,0x01},     // ASCII - 117 u
        {0x1C,0x02,0x01,0x02,0x1C},     // ASCII - 118 v
        {0x1E,0x01,0x0F,0x01,0x1E},     // ASCII - 119 w
        {0x11,0x0A,0x04,0x0A,0x11},     // ASCII - 120 x
        {0x11,0x0A,0x04,0x08,0x10},     // ASCII - 121 y
        {0x11,0x13,0x15,0x19,0x11},     // ASCII - 122 z
        {0x18,0x66,0x81,0x81,0x00},     // ASCII - 123 {
        {0x00,0x00,0xFF,0x00,0x00},     // ASCII - 124 |
        {0x00,0x81,0x81,0x66,0x18},     // ASCII - 125 }
        {0x0C,0x10,0x08,0x04,0x18},     // ASCII - 126 ~
    };

    char currentchar = 0;
    int LED_MASK = 0xFFFFFFFF;


    //pc.printf("Starting ADXL345 test...\r\n");
//   pc.printf("Device ID is: 0x%02x\r\n", accelerometer.getDevId());
    wait(3);

    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);

    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);

    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);

    //Measurement mode.
    accelerometer.setPowerControl(0x08);

    while (1) {
        global=0;

        while(1) {
            // test = xbee2.readable();

            if(xbee2.readable()) {
                character =  xbee2.getc();

                if(character == 13) {

                    buffer[global] = '\0';
                    break;
                } else {
                    buffer[global]= character;
                    global++;

                }
            }

        }

        pc1.printf("\n\rbuffer = %s\n\r" ,buffer);
        //pc1.printf(" \n\rBuffer = %s", buffer);
        len1 = strlen(buffer);

        for( int m =0; m < (len1 + 2); m++) {

            text[m] = 0x20;
        }

        for( int m =(len1 + 2); m <( 2*len1 + 2); m++) {

            text[m] = buffer[m - (len1 +2)];
        }

        text[2*len1 + 2] = '\0';
        len = strlen(text);
        for(int p =0; p <len; p++) {
            pc1.printf("%c", text[p]);
        }
        pc1.printf("\n\rstrlen(text) = %d", len);
        float waitvalue = 0.08 / ((6*len));



        while(!(xbee2.readable())) {
            red = 0;
            green = 0;
            blue = 0;


            do {
                accelerometer.getOutput(readings);
                if(xbee2.readable())
                    break;
            } while((int16_t)readings[1] < 50);
            i = 0;

            while(text[i] != '\0') {

                /*
                led8 = 0;
                led7 = 0;
                led6 = 0;
                led5 = 0;
                led4 = 0;
                led3 = 0;
                led2 = 0;
                led1 = 0; */
                for( int m=0; m < 8; m++) {
                    red = 0;
                    green = 0;
                    blue = 0;
                    RGB_LED(red,green,blue);
                }
                wait(waitvalue);
                currentchar = text[i];

                for( int m =0; m <5; m++) {
                    char mal = font[currentchar - 0x20][m];
                    led8 = mal & 0x80;
                    led7 = mal & 0x40;
                    led6 = mal & 0x20;
                    led5 = mal & 0x10;
                    led4 = mal & 0x08;
                    led3 = mal & 0x04;
                    led2 = mal & 0x02;
                    led1 = mal & 0x01;
                    if(led8 == 1) {
                        if( i == (len1+2)) {
                            green = 200;
                            red = 0;
                            blue = 0;
                        } else if ( i == (len1+3)) {
                            green = 0;
                            red = 0;
                            blue = 200;
                        } else if ( i == (len1 + 4)) {
                            green = 200;
                            red = 200;
                            blue = 0;
                        } else {
                            green = 0;
                            red = 200;
                            blue = 0;
                        }
                        RGB_LED(red,green,blue);
                    } else {

                        red = 0;
                        green = 0;
                        blue = 0;
                        RGB_LED(red,green,blue);

                    }

                    if(led7 == 1) {
                        if( i == (len1+2)) {
                            green = 200;
                            red = 0;
                            blue = 0;
                        } else if ( i == (len1+3)) {
                            green = 0;
                            red = 0;
                            blue = 200;
                        } else if ( i == (len1 + 4)) {
                            green = 200;
                            red = 200;
                            blue = 0;
                        } else {
                            green = 0;
                            red = 200;
                            blue = 0;
                        }
                        RGB_LED(red,green,blue);
                    } else {

                        red = 0;
                        green = 0;
                        blue = 0;
                        RGB_LED(red,green,blue);

                    }

                    if(led6 == 1) {
                        if( i == (len1+2)) {
                            green = 200;
                            red = 0;
                            blue = 0;
                        } else if ( i == (len1+3)) {
                            green = 0;
                            red = 0;
                            blue = 200;
                        } else if ( i == (len1 + 4)) {
                            green = 200;
                            red = 200;
                            blue = 0;
                        } else {
                            green = 0;
                            red = 200;
                            blue = 0;
                        }
                        RGB_LED(red,green,blue);
                    } else {

                        red = 0;
                        green = 0;
                        blue = 0;
                        RGB_LED(red,green,blue);

                    }

                    if(led5 == 1) {
                        if( i == (len1+2)) {
                            green = 200;
                            red = 0;
                            blue = 0;
                        } else if ( i == (len1+3)) {
                            green = 0;
                            red = 0;
                            blue = 200;
                        } else if ( i == (len1 + 4)) {
                            green = 200;
                            red = 200;
                            blue = 0;
                        } else {
                            green = 0;
                            red = 200;
                            blue = 0;
                        }
                        RGB_LED(red,green,blue);
                    } else {

                        red = 0;
                        green = 0;
                        blue = 0;
                        RGB_LED(red,green,blue);

                    }

                    if(led4 == 1) {
                        if( i == (len1+2)) {
                            green = 200;
                            red = 0;
                            blue = 0;
                        } else if ( i == (len1+3)) {
                            green = 0;
                            red = 0;
                            blue = 200;
                        } else if ( i == (len1 + 4)) {
                            green = 200;
                            red = 200;
                            blue = 0;
                        } else {
                            green = 0;
                            red = 200;
                            blue = 0;
                        }
                        RGB_LED(red,green,blue);
                    } else {

                        red = 0;
                        green = 0;
                        blue = 0;
                        RGB_LED(red,green,blue);

                    }

                    if(led3 == 1) {
                        if( i == (len1+2)) {
                            green = 200;
                            red = 0;
                            blue = 0;
                        } else if ( i == (len1+3)) {
                            green = 0;
                            red = 0;
                            blue = 200;
                        } else if ( i == (len1 + 4)) {
                            green = 200;
                            red = 200;
                            blue = 0;
                        } else {
                            green = 0;
                            red = 200;
                            blue = 0;
                        }
                        RGB_LED(red,green,blue);
                    } else {

                        red = 0;
                        green = 0;
                        blue = 0;
                        RGB_LED(red,green,blue);

                    }

                    if(led2 == 1) {
                        if( i == (len1+2)) {
                            green = 200;
                            red = 0;
                            blue = 0;
                        } else if ( i == (len1+3)) {
                            green = 0;
                            red = 0;
                            blue = 200;
                        } else if ( i == (len1 + 4)) {
                            green = 200;
                            red = 200;
                            blue = 0;
                        } else {
                            green = 0;
                            red = 200;
                            blue = 0;
                        }
                        RGB_LED(red,green,blue);
                    } else {

                        red = 0;
                        green = 0;
                        blue = 0;
                        RGB_LED(red,green,blue);

                    }

                    if(led1 == 1) {
                        if( i == (len1+2)) {
                            green = 200;
                            red = 0;
                            blue = 0;
                        } else if ( i == (len1+3)) {
                            green = 0;
                            red = 0;
                            blue = 200;
                        } else if ( i == (len1 + 4)) {
                            green = 200;
                            red = 200;
                            blue = 0;
                        } else {
                            green = 0;
                            red = 200;
                            blue = 0;
                        }
                        RGB_LED(red,green,blue);
                    } else {

                        red = 0;
                        green = 0;
                        blue = 0;
                        RGB_LED(red,green,blue);

                    }
                    wait(waitvalue);

                }
                /*led8 = 0;
                led7 = 0;
                led6 = 0;
                led5 = 0;
                led4 = 0;
                led3 = 0;
                led2 = 0;
                led1 = 0;*/
                for( int j=0; j< 8; j++) {
                    red = 0;
                    green = 0;
                    blue = 0;
                    RGB_LED(red,green,blue);
                }
                wait(waitvalue);
                i++;
            }
            do {
                accelerometer.getOutput(readings);
                if(xbee2.readable())
                    break;
            } while((int16_t)readings[1] > -50);
        }
    }
}
