#include "mbed.h"
#include "SDFileSystem.h"
#include "NokiaLCD.h"
#include "myBMP.h"
#include "mpr121.h"
#include <string>
#include <vector>
#include <cctype>

SDFileSystem sd(p5, p6, p7, p8, "sd");
NokiaLCD lcd(p11, p13, p14, p15, NokiaLCD::LCD6610);
I2C i2c(p9,p10);
Mpr121 touch(&i2c, Mpr121::ADD_VSS);
Serial pc(USBTX,USBRX);
InterruptIn interrupt(p26);
DigitalOut led1(LED1);
vector<string> f;
string file;
int value;
bool  zoom= false;
bool select_pic[12];

void fallInterrupt()
{  // Interrupt service routine to display the image according to the key pressed
    value=touch.read(0x00);
    value +=touch.read(0x01)<<8; // value of the key pressed is assigned to the variable 'value'

    pc.printf("%d\r\n",value);
    switch (value) {
        case 0:
            break;

        case 1: {
            select_pic[0] = true;
            zoom = true;
            break;
        }
        case 2: {
            select_pic[3] = true;
            zoom = true;
            break;
        }
        case 4: {
            select_pic[5] = true;
            zoom = true;
            break;
        }
        case 8: {
            select_pic[2] = true;
            zoom = true;
            break;
        }
        case 16: {
            select_pic[1] = true;
            zoom = true;
            break;
        }
        case 32: {
            select_pic[4] = true;
            zoom = true;
            break;
        }

        default:

            break;
    }

}

void open_dir(char *dir)
{   // Opening the SD card directory and pushing the files into the directory 
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    while((dirp = readdir(dp)) != NULL) {
        f.push_back(string(dirp->d_name));
    }
}

int main()
{

    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    lcd.background(0xFFFFFF);
    lcd.foreground(0xFFFFFF);
    lcd.cls();
    open_dir("/sd");
    led1 = 1;

    while(1) {

        if(zoom) {
            __disable_irq();
            for(int i =0; i <f.size(); i++) {
                if (select_pic[i] == true) {
                    file = f[i];
                    select_pic[i] = false;
                }
            }

            RGBApixel *Colors = new RGBApixel [2];
            file = "/sd/" + file;
            lcd.background(0x000000);
            lcd.foreground(0x000000);
            lcd.cls();
            ReadBMPFromFile(file.c_str(), Colors, &lcd); // Function to display image on the nokia LCD. Refer myBMP.cpp for complete functionality.


            zoom = false;
            __enable_irq();
        }

        led1 = !led1;
        wait(0.2);
    }
}
