#include "ADXL345.h"
#include "mbed.h"
DigitalOut latch(p15);
DigitalOut enable(p16);
DigitalIn s1(p29);
DigitalIn s2(p30);
//Cycles through different colors on RGB LED
SPI spi(p11, p12, p13);
//Use SPI hardware to write color values to LED driver chip

PortOut ledport(Port1, 0xFFFFFFFF);

ADXL345 accelerometer(p5, p6, p7, p8);
//Serial pc(USBTX, USBRX);

DigitalOut led8(p28);
DigitalOut led7(p27);
DigitalOut led6(p26);
DigitalOut led5(p25);
DigitalOut led4(p24);
DigitalOut led3(p23);
DigitalOut led2(p22);
DigitalOut led1(p21);

// ------------------------- Zigbee -------------

Serial pc1(USBTX, USBRX);
const int redcolor[10][8]={
{255 , 250,    0,    0 ,   0,    0,  244,  255},
  {251,    0,    0,  219  ,225  ,  0   , 0  ,244},
   { 0  ,  0  ,255 , 255,  255 , 255 ,   0 ,   0},
    {0 , 222,  255,  254,  254,  255,  242 ,   0},
    {0 , 252 , 254 , 254 , 254 , 254 , 255,    0},
    {0 , 254  ,254 , 254 , 254 , 254 , 255  ,  0},
    {0 , 230  ,255 , 254,  254,  255,  246,    0},
    {0  ,  0 , 255 , 255 , 255 , 255,    0,    0},
  {244   , 0  ,  0 , 244 , 250  ,  0  ,  0  ,232},
  {255 , 238 ,   0 ,   0 ,   0 ,   0 , 227 , 255}
};

const int greencolor[10][8] = {

  {255,  250 ,   0 ,   0 ,   0 ,   0 , 244 , 255},
  {251   , 0  ,  0 , 219  ,217   , 0  ,  0 , 244},
   { 0   , 0  ,253 , 254,  245 , 255 ,   0,    0},
    {0 , 212 , 246  ,254 , 242 , 244  ,230   , 0},
    {0 , 240 , 242 , 254  ,242 , 242 , 249 ,   0},
    {0 , 241 , 242 , 254 , 242,  242 , 250,    0},
    {0  ,220 , 245 , 255 , 242 , 243,  235 ,   0},
    {0   , 0 , 255 , 255 , 243 , 255  ,  0 ,   0},
 { 244   , 0  ,  0 , 244  ,242   , 0   , 0 , 232},
 { 255 , 238  ,  0 ,   0 ,   0 ,   0 , 228,  255}
};

const int bluecolor[10][8]= {
 {255 , 251    ,0,    0 ,   0 ,   0,  246,  255},
  {253  ,  0  ,  0  ,  0 ,   0  ,  0 ,   0 , 247},
   { 0  ,  0  ,  0   , 0  ,  0 ,   0 ,   0 ,   0},
    {0  ,  0 ,   0  ,  0 ,   0   , 0  ,  0   , 0},
    {0  ,  0 ,   0 ,   0 ,   0 ,   0,    0 ,   0},
    {0   , 0   , 0   , 0  ,  0  ,  0   , 0  ,  0},
    {0  ,  0  ,  0  ,  0  ,  0  ,  0  ,  0 ,   0},
    {0   , 0 ,   0  ,  0  ,  0 ,   0   , 0  ,  0},
  {247  ,  0  ,  0  ,  0 ,   0  ,  0 ,   0,  237},
  {255 , 240  ,  0  ,  0  ,  0 ,   0,  232  ,255}
};
void RGB_LED(int red, int green, int blue)
{
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}


int main()
{
    int readings[3] = {0, 0, 0};
    int i = 0;
    const char text1[50] = "HI";
    int len;
    char character;
    char currentchar = 0;
    int LED_MASK = 0xFFFFFFFF;

    int red=0;
    int green=0;
    int blue=0;
    spi.format(16,0);
    spi.frequency(500000);
    enable=0;
    latch=0;



    len = 0;
    for(int n = 0; text1[n] != '\0'; n++) {
        len++;
    }
    float waitvalue = 0.06/((6*len) + 1);
    pc1.printf("text1 = %s\n\r", text1);
//   pc.printf("Device ID is: 0x%02x\r\n", accelerometer.getDevId());
    wait(3);

    //Go into standby mode to configure the device.
    accelerometer.setPowerControl(0x00);

    //Full resolution, +/-16g, 4mg/LSB.
    accelerometer.setDataFormatControl(0x0B);

    //3.2kHz data rate.
    accelerometer.setDataRate(ADXL345_3200HZ);

    //Measurement mode.
    accelerometer.setPowerControl(0x08);

    while (1) {

        red = 0;
        green = 0;
        blue = 0;

        accelerometer.getOutput(readings);

        do {
            accelerometer.getOutput(readings);
            pc1.printf("| 1st while reading value = %i\n\r",(int16_t)readings[1]);
        } while((int16_t)readings[1] < 50);

        i = 0;
        //while(text1[i] != '\0')
        {

            /*   led8 = 0;
               led7 = 0;
               led6 = 0;
               led5 = 0;
               led4 = 0;
               led3 = 0;
               led2 = 0;
               led1 = 0;   */

            for( int m=0; m< 8; m++) {
                red = 0;
                green = 0;
                blue = 0;
                RGB_LED(red,green,blue);
            }
            wait(waitvalue);

            for( int m=0; m< 8; m++) {
                red = 0;
                green = 0;
                blue = 0;
                RGB_LED(red,green,blue);
            }
            wait(waitvalue);

            //currentchar = text1[i];

            for( int m =0; m < 10; m++) {
                /*char mal = font[currentchar - 0x20][m];
                led8 = mal & 0x80;
                led7 = mal & 0x40;
                led6 = mal & 0x20;
                led5 = mal & 0x10;
                led4 = mal & 0x08;
                led3 = mal & 0x04;
                led2 = mal & 0x02;
                led1 = mal & 0x01;*/

                // if(led8 == 1)

                green = greencolor[m][7];
                red = redcolor[m][7];
                blue = bluecolor[m][7];
                RGB_LED(red,green,blue);

                green = greencolor[m][6];
                red = redcolor[m][6];
                blue = bluecolor[m][6];
                RGB_LED(red,green,blue);

                green = greencolor[m][5];
                red = redcolor[m][5];
                blue = bluecolor[m][5];
                RGB_LED(red,green,blue);

                green = greencolor[m][4];
                red = redcolor[m][4];
                blue = bluecolor[m][4];
                RGB_LED(red,green,blue);

                green = greencolor[m][3];
                red = redcolor[m][3];
                blue = bluecolor[m][3];
                RGB_LED(red,green,blue);

                green = greencolor[m][2];
                red = redcolor[m][2];
                blue = bluecolor[m][2];
                RGB_LED(red,green,blue);

                green = greencolor[m][1];
                red = redcolor[m][1];
                blue = bluecolor[1][m];
                RGB_LED(red,green,blue);

                green = greencolor[m][0];
                red = redcolor[m][0];
                blue = bluecolor[m][0];
                RGB_LED(red,green,blue);


                wait(waitvalue);
            }
            /*  led8 = 0;
              led7 = 0;
              led6 = 0;
              led5 = 0;
              led4 = 0;
              led3 = 0;
              led2 = 0;
              led1 = 0; */

            for( int j=0; j< 8; j++) {
                red = 0;
                green = 0;
                blue = 0;
                RGB_LED(red,green,blue);
            }
            wait(waitvalue);

            for( int j=0; j< 8; j++) {
                red = 0;
                green = 0;
                blue = 0;
                RGB_LED(red,green,blue);
            }
            wait(waitvalue);

        }

        do {
            accelerometer.getOutput(readings);
            pc1.printf("| 2nd while reading value = %i\n\r",(int16_t)readings[1]);
        } while((int16_t)readings[1] > -50);

    }
}
