#include "mbed.h"
#include "USBHostGamepad.h"
#include "Servo.h"
#include "WT2003M03.h"
#include "Motorfader.h"
#include "stdio.h"
#include "stdlib.h"
#include "math.h"
#include "string"

 #define SCREEN_WIDTH 128
 #define SCREEN_HEIGHT 160
 
USBHostGamepad *pad;
//Servo myservo1(D3);
Servo tyre_R(D5);     //TYRE RIGHT
Servo tyre_L(D6);     //TYRE LEFT
//Servo myservo4(D4);
PwmOut eye_R(PB_2);
PwmOut eye_L(PB_1);
WT20003M03 myaudio(PC_10,PC_11);
Motorfader myfader(PC_0,A0,A1);
Ticker _flipper;
// LED
//DigitalOut red(PB_5);
//DigitalOut yellow(PA_10);
 
void int_frame() {
    myfader.update();
}

int main()
{    
float panchPos,tempR,tempL;
     
    _flipper.attach(&int_frame, 0.01f);
    myaudio.Play(0x0001);
//            myaudio.Play(0xfff0);
/*
        myaudio.volume(1);
        myaudio.Play(0x0001);
        wait(3.0); // 1 second
        myaudio.volume(16);
        myaudio.Play();
        wait(3.0); // 1 second
        myaudio.volume(31);
        myaudio.Play();
        printf("s=%d",myaudio.ReadState());
        wait(3.0); // 1 second


        myfader.set(0.0,1.0);
        wait(3.0); // 1 second
        myfader.set(0.5,1.0);
        wait(3.0); // 1 second
        myfader.set(1.0,1.0);
        wait(3.0); // 1 second
        myfader.set(0.5,1.0);
        wait(3.0); // 1 second
*/

    // USB Gmaepad Initialize
    pad = new USBHostGamepad();
    if (!pad->connect()) {
        printf("USB Gamepad not found.\r\n");
        while(1);
    }

    while(((pad->report[6] != 0xf7) && (pad->report[7] != 0xb9)))
    {
        USBHost::poll();
        wait_ms(16);
    }
    while(1)
    {
        USBHost::poll();
        
//        red = pad->report[4] & 0x20;
//        yellow = pad->report[4] & 0x40;
        
//        printf("%02x %02x %02x %02x %02x %02x %02x %02x\r\n", pad->report[0],pad->report[1],pad->report[2],pad->report[3],pad->report[4],pad->report[5],pad->report[6],pad->report[7]);
        wait_ms(16);
//zengo
        tempR = ((pad->report[3]))/255.0f;      //sayuu
        tempL = (255.0f-(pad->report[3]))/255.0f;      //sayuu
//printf("0R=%1.2f L=%1.2f ",tempR,tempL);
//kaiten
        tempR -= (((pad->report[2]))/255.0f)-0.5f;      //sayuu
        tempL += ((255.0f-(pad->report[2]))/255.0f)-0.5f;      //sayuu
//printf("1R=%1.2f L=%1.2f ",tempR,tempL);
        if(tempR >1.0f)tempR = 1.0f;
        if(tempR <0.0f)tempR = 0.0f;
        if(tempL >1.0f)tempL = 1.0f;
        if(tempL <0.0f)tempL = 0.0f;
//printf("2R=%1.2f L=%1.2f\r\n",tempR,tempL);

        tyre_R = tempR;
        tyre_L = tempL;
//        pad->report[3]      //zengo
        panchPos = (128-(pad->report[4]))/128.0f;
        if(panchPos < 0.0f) panchPos = 0.0f;
        myfader.set(panchPos,1.0);

        if(pad->report[0] & 0x10)
        {
            eye_R = 1.0f;
            eye_L = 1.0f;            
        }
        if(pad->report[0] & 0x20)
        {
            eye_R = 0.0f;
            eye_L = 0.0f;            
        }
        if(pad->report[0] & 0x01)
        {
            myaudio.Play(0x0001);
            wait_ms(10);
        }
        if(pad->report[0] & 0x02)
        {
            myaudio.Play(0x0002);
            wait_ms(10);
        }
        if(pad->report[0] & 0x08)
        {
            myaudio.Play(0x0003);
            wait_ms(10);
        }
printf("s=%d \r\n",myaudio.ReadState());

    }
}
