/* mbed WT20003M03 Library
 * Copyright (c) 2019 abanum
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
  
#ifndef MBED_WT20003M03_H
#define MBED_WT20003M03_H

#include "mbed.h"

/** WT20003M03 control class, based on a PwmOut
 *
 * Example:
 * @code
 * // Continuously sweep the servo through it's full range
 * #include "mbed.h"
 * #include "WT20003M03.h"
 * 
 * WT20003M03 myaudio(p21);
 * 
 * int main() {
       mysound.volume(8);
 *     while(1) {
 *             myaudio.play();
 *             wait(10);
 *     }
 * }
 * @endcode
 */
class WT20003M03 {

public:
    /** Create a servo object connected to the specified PwmOut pin
     *
     * @param pin DigitalOut pin to connect to 
     */
    WT20003M03(PinName txpin,PinName rxpin);
    
    /** Set the addres Play address section audio
     *
     * @param addres 
     */
    void Play(unsigned int address);
    
    /**  Play/recover current address audio
     *
     * @param Play/recover current address audio.
     */
    void Play();
    
    /** Set the volume
     *
     * @param volune audio volume(0-16) in volume
     */
    void volume(unsigned int volume);

    /**  Pause current address audio
     *
     * @param Pause current address audio.
     */
    void Pause();
    
    /**  After send command, single cycle
     *
     * @param After send command, single cycle.
     */
    void Stop();
   
    /**  Play next
     *
     * @param Play next.
     */
    void Next();

    /**  Play Previous
     *
     * @param Play Previous.
     */
    void Previous();

    /**  Read volume
     *
     * @param Read volume.
     */
    char ReadVolume();

    /**  Read state
     *
     * @param Read state.
     */
    char ReadState();

protected:
    Serial _audio;
    unsigned int _address;
    unsigned int _volume;
};

#endif
