/* mbed WT20003M03 Library
 *  
 * Copyright (c) 2007-2010 sford, cstyles
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "WT2003M03.h"
#include "mbed.h"

WT20003M03::WT20003M03(PinName txpin,PinName rxpin) : _audio(txpin,rxpin) {
    wait_ms(10);
}

void WT20003M03::Play(unsigned int address) {
    _audio.putc(0x7E);
    _audio.putc(0x05);
    _audio.putc(0xA2);
    _audio.putc((address >> 8) & 0xFF);
    _audio.putc( address       & 0xFF);
    _audio.putc((0x05 + 0xA2 + ((address >> 8) & 0xFF) + (address & 0xFF)) & 0xFF);
    _audio.putc(0xEF);
    wait_ms(10);
}

void WT20003M03::Play() {
    _audio.putc(0x7E);
    _audio.putc(0x03);
    _audio.putc(0xAA);
    _audio.putc(0xAD);
    _audio.putc(0xEF);
    wait_ms(10);
}

void WT20003M03::volume(unsigned int volume) {
    _audio.putc(0x7E);
    _audio.putc(0x04);
    _audio.putc(0xAE);
    _audio.putc( volume & 0xff);
    _audio.putc((0x04 + 0xAE + (volume & 0xFF)) & 0xFF);
    _audio.putc(0xEF);
    wait_ms(10);
}


void WT20003M03::Pause() {
    Play() ;
}

void WT20003M03::Stop() {
    _audio.putc(0x7E);
    _audio.putc(0x03);
    _audio.putc(0xAB);
    _audio.putc(0xAE);
    _audio.putc(0xEF);
    wait_ms(10);
}

void WT20003M03::Next() {
    _audio.putc(0x7E);
    _audio.putc(0x03);
    _audio.putc(0xAC);
    _audio.putc(0xAF);
    _audio.putc(0xEF);
    wait_ms(10);
}

void WT20003M03::Previous() {
    _audio.putc(0x7E);
    _audio.putc(0x03);
    _audio.putc(0xAD);
    _audio.putc(0xB0);
    _audio.putc(0xEF);
    wait_ms(10);
}

char WT20003M03::ReadVolume() {
    _audio.putc(0x7E);
    _audio.putc(0x03);
    _audio.putc(0xC1);
    _audio.putc(0xC4);
    _audio.putc(0xEF);
    _audio.getc();
    return _audio.getc();
}
char WT20003M03::ReadState() {
    _audio.putc(0x7E);
    _audio.putc(0x03);
    _audio.putc(0xC2);
    _audio.putc(0xC5);
    _audio.putc(0xEF);
    return _audio.getc();
}
