#include "mbed.h"
//                   button config for PSP
BusOut Bout(p15, //X batu
            p16, // shikaku
            p17, // maru
            p18, // sankaku
            p19, // sita
            p20, // ue
            p21, // migi
            p22, // hidari
            p23, //L left
            p24  //R right
            );

static unsigned int now_frame = 0;
static unsigned int Bdata_n = 0;
static unsigned int mode = 0;

struct {
    unsigned int frame;
    int key;
    } Bdata[2800];

//syuuhen settei
InterruptIn event(p8);
DigitalIn start(p8);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
Serial pc(USBTX, USBRX); // tx, rx


Ticker flipper;

void int_frame() {
    led2 = !led2;
    if (now_frame == Bdata[Bdata_n].frame ){
        Bout =  Bdata[Bdata_n].key;
        Bdata_n ++;
        if (Bdata[Bdata_n].frame == 0){
            flipper.detach(); //frame == 0 is end
            wait(0.1);
            now_frame = 0;
            Bdata_n = 0;
            Bout =  0;
            mode = 0;
        }
    }
    now_frame ++;   
//pc.printf("now_frame=%d Bdata_n=%d\r\n",now_frame,Bdata_n);

}

void trigger() {
    wait(0.1);
    if (!start)return; //key filter

    switch(mode){
        case 0:
            flipper.attach(&int_frame, 1.0f/59.94f); // the address of the function to be attached (flip) and the interval (2 seconds)
            mode = 1;
            break;
        case 1:
            flipper.detach(); //frame == 0 is end
            wait(0.1);
            now_frame = 0;
            Bdata_n = 0;
            Bout =  0;
            mode = 0;
            break;
    }            
//    pc.printf("triggered!\r\n");
}

int main() {
    event.mode (PullUp); //hard de pullup sinaito matomoni ugokanai
    event.rise(&trigger);


//    Bdata[0].key = 0;       Bdata[0].frame = 1;
//    Bdata[1].key = 1;       Bdata[1].frame = 2;
///    Bdata[2].key = 0;       Bdata[2].frame = 3;
//    Bdata[3].key = 2;       Bdata[3].frame = 4;
//    Bdata[4].key = 4;       Bdata[4].frame = 5;
//    Bdata[5].key = 0;       Bdata[5].frame = 6;
//    Bdata[6].key = 0;       Bdata[6].frame = 7;
//    Bdata[7].key = 8;       Bdata[7].frame = 8;
//    Bdata[8].key = 0;       Bdata[8].frame = 9;
//    Bdata[9].key = 16;       Bdata[9].frame = 10;
//    Bdata[10].key = 0;       Bdata[10].frame = 11;
//    Bdata[11].key = 32;       Bdata[11].frame = 12;
//    Bdata[12].key = 0;       Bdata[12].frame = 14;
//    Bdata[13].key = 0;       Bdata[13].frame = 15;
//    Bdata[14].key = 0;       Bdata[14].frame = 0;
//datafile read & Analysis
    LocalFileSystem local( "local" );
    char            s[ 3 ];
    char            buf[ 100 ];
    FILE            *fp;

    printf( "\r\nreading a data file.\r\n" );

    if ( NULL == (fp = fopen( "/local/data.txt", "r" )) ) {
        pc.printf( "\r\nError: The data file cannot be accessed\r\n" );
        while(1) {
            led1 = !led1;
            wait(0.2);
        }
//        return -1;
    }
//Analysis
    int onkey = 0,count = 0,file_stat,tempkey,i,k;
    unsigned int onframe = 0,offframe = 0,tempframe,onoffset,offoffset;
    Bdata[0].frame = 0;
    Bdata[0].key = 0;
    while (1) {
 //printf("file stat %d\n\r",file_stat);
        if ((int)fgets(buf, sizeof(buf), fp) == NULL)break;
        if ((buf[0] == '#') or (buf[0] == '/')){
            printf(buf);        
//            while(1){
//                file_stat = fgetc(fp);
//                printf("%c",file_stat);
//                if (file_stat == '\n')break;
//            }
            continue;
        }
        file_stat = sscanf(buf,"%2s,%d,%d", s,&onframe,&offframe);
        if (file_stat != 3){
            printf("para err\r\n");
            while(1) {
                led1 = !led1;
                wait(0.2);
            }
        }

        if (strcmp(s,"ba") == 0){onkey =   1;}
        if (strcmp(s,"si") == 0){onkey =   2;}
        if (strcmp(s,"ma") == 0){onkey =   4;}
        if (strcmp(s,"sa") == 0){onkey =   8;}
        if (strcmp(s,"dn") == 0){onkey =  16;}
        if (strcmp(s,"up") == 0){onkey =  32;}
        if (strcmp(s,"ri") == 0){onkey =  64;}
        if (strcmp(s,"le") == 0){onkey = 128;}
        if (strcmp(s,"lt") == 0){onkey = 256;}
        if (strcmp(s,"rt") == 0){onkey = 512;}

        if (offframe == 0) offframe = onframe + 2;

//        pc.printf("%d %s %d %x %d \r\n",file_stat, s,onframe,onkey,offframe);
        
        if (count == 0){
            Bdata[0].frame = onframe;
            Bdata[0].key = onkey;
            Bdata[1].frame = offframe;
            Bdata[1].key = 0;
            count = 2;
        } else {

            Bdata[count].frame = onframe;
            Bdata[count].key = onkey;
            count ++;

            Bdata[count].frame = offframe;
//        Bdata[count].key = offkey;
            Bdata[count].key = 0;
            count ++;
//onframe irekae check
            for (i = count-2;i>=0;i--){
                if (Bdata[i].frame < Bdata[i-1].frame){
                    tempframe        = Bdata[i].frame;
                    Bdata[i].frame   = Bdata[i-1].frame;
                    Bdata[i-1].frame = tempframe ;
                    tempkey          = Bdata[i].key;
                    Bdata[i].key     = Bdata[i-1].key;
                    Bdata[i-1].key   = tempkey ;
printf("chg on index=%d\r\n",i);
                    continue;
                }
                break;
            }            
            onoffset = i;

//offframe irekae check
            for (i = count-1;i>=0;i--){
                if (Bdata[i].frame < Bdata[i-1].frame){
                    tempframe        = Bdata[i].frame;
                    Bdata[i].frame   = Bdata[i-1].frame;
                    Bdata[i-1].frame = tempframe ;
                    tempkey          = Bdata[i].key;
                    Bdata[i].key     = Bdata[i-1].key;
                    Bdata[i-1].key   = tempkey ;
printf("chg off index=%d\r\n",i);
                    continue;
                }
                break;
            }            
            offoffset = i;
//printf("-----on %d off %d\r\n",onoffset,offoffset);
//    for(k=0;k<count;k++) pc.printf("%x %d \r\n\r\n",Bdata[k].key, Bdata[k].frame);
    
            Bdata[onoffset].key = Bdata[onoffset-1].key;
            if (Bdata[onoffset].frame == Bdata[onoffset-1].frame){
                for(i = onoffset;i<count;i++){
                    Bdata[i-1].frame   = Bdata[i].frame;
                    Bdata[i-1].key     = Bdata[i].key;
                }
                --onoffset;
                --offoffset;
                --count;
//    for(k=0;k<count;k++) pc.printf("%x %d \r\n",Bdata[k].key, Bdata[k].frame);
            }
//printf("onframe same %d\r\n",onoffset);
//printf("-----on %d off %d c %d\r\n",onoffset,offoffset,count);
            Bdata[offoffset].key = Bdata[offoffset-1].key;
            if (Bdata[offoffset].frame == Bdata[offoffset-1].frame){
                 for(i = offoffset;i<count;i++){
                    Bdata[i-1].frame   = Bdata[i].frame;
                    Bdata[i-1].key     = Bdata[i].key;
printf("****\r\n");
                }
               --offoffset;
               --count;
//    for(k=0;k<count;k++) pc.printf("%x %d \r\n",Bdata[k].key, Bdata[k].frame);
printf("offframe same %d\r\n",offoffset);
            }
            for(i = count-1;i>=(long)onoffset;i--){
                Bdata[i].key |= onkey;
// printf("++++on c %d i %d\r\n",count,i);
            }

            for(i = count-1;i>=(long)offoffset;i--){
                Bdata[i].key &= ~onkey;
// printf("++++off\r\n");
            }

//    for(k=0;k<count;k++) pc.printf("%x %d \r\n",Bdata[k].key, Bdata[k].frame);

        }
        if (count >=2800) break;
    };
    fclose( fp );

    Bdata[count].frame = 0;
    Bdata[count].key = 0;
    for(k=0;k<count+1;k++) pc.printf("%x %d \r\n",Bdata[k].key, Bdata[k].frame);


        led1 = 1;


    while(1) {
    }
}
