/* mbed Motorfader Library
 * Copyright (c) 2019 abanum
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
  
#ifndef MBED_Motorfader_H
#define MBED_Motorfader_H

#include "mbed.h"

/** Motorfader control class, based on a PwmOut
 *
 * Example:
 * @code
 * // Continuously sweep the servo through it's full range
 * #include "mbed.h"
 * #include "WT20003M03.h"
 * 
 * WT20003M03 myaudio(p21);
 * 
 * int main() {
       mysound.volume(8);
 *     while(1) {
 *             myaudio.play();
 *             wait(10);
 *     }
 * }
 * @endcode
 */
class Motorfader {

public:
    /** Create a servo object connected to the specified PwmOut pin
     *
     * @param pin DigitalOut pin to connect to 
     */
    Motorfader(PinName analogpin,PinName cwpin,PinName ccwpin);
    
    /** Set position
     *
     * @param addres 
     */
    void set(float pos,float vel);
    
    /**  Get position
     *
     * @param Read volume.
     */
    float get();

    void update();

protected:
    AnalogIn _faderPos;
    PwmOut _cwpwm;
    PwmOut _ccwpwm;
    float _setPos;
    float _setVel;
    float _nowPos;
    float _oldPos;
//    unsigned int _volume;
};

#endif
