/* mbed Motorfader Library
 *  
 * Copyright (c) 2007-2010 sford, cstyles
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#include "Motorfader.h"
#include "mbed.h"

Motorfader::Motorfader(PinName anarogpin,PinName cwpin,PinName ccwpin) : _faderPos(anarogpin) ,_cwpwm(cwpin),_ccwpwm(ccwpin) {
    _cwpwm.period(0.020);
    _ccwpwm.period(0.020);
    _cwpwm.write(1.0);
    _ccwpwm.write(1.0);
    _setPos = 0.0;
    _setVel = 1.0;
    wait_ms(10);
}

void Motorfader::set(float pos,float vel ) {
    _setPos = pos;
    _setVel = vel;
    wait_ms(10);
}

float Motorfader::get() {
    return _faderPos.read();
}

void Motorfader::update() {
float P,D = 0;
    _nowPos = _faderPos.read();
    _cwpwm.write(0.0);
    _ccwpwm.write(0.0);

    P = abs(_setPos - _nowPos)*4.0f;
    if (P >1.0f )
    { 
        P =1.0f;
//        _oldPos = _nowPos;
    }
//    D = -abs(_oldPos - _nowPos)*1.0f;
//    _oldPos = _nowPos;
    if((_nowPos+0.03f) < _setPos)
    {
        _cwpwm.write(_setVel*(P+D));
        _ccwpwm.write(0.0f);
//        printf("inc ");
    }
    if((_nowPos-0.03f) > _setPos)
    {
        _cwpwm.write(0.0f);
        _ccwpwm.write(_setVel*(P+D));
//        printf("dec ");
    }
//        printf("nowpos=%1.3f setpos==%1.3f\r\n",_nowPos,_setPos);

}
