#include "mbed.h"

DigitalOut myled(LED_USER);
DigitalIn key1(USER_BUTTON0);
Serial pc(USBTX, USBRX); // tx, rx

Ticker flipper;
#define MODE      2    //MODE
#define IN        3    //IN
#define EV_IN     1    //IN
#define EV_MODE   2    //MODE
volatile unsigned char key_dat = 0;
volatile unsigned char key_old = 0;
volatile unsigned char key_buf[2] = {0,0};
volatile unsigned char key_ev[2] = {0,0};
/*タイマーデータ*/
#define MODE_1S 1000
#define MODE_10S 10000
#define REP_1000MS 1000
#define REP_500MS 500
#define EV_10S     4    //10Sイベント
//volatile unsigned char  timer_dat = 0;
volatile unsigned char  timer_ev[1] = {0};
//volatile unsigned int  mode_1s_t = 0;
volatile unsigned int  mode_10s_t = 0;
int c_in = 0,mode = 0;

void flip() {
unsigned char  x;
    key_buf[0] <<= 1;
    if (!key1) {
        key_buf[0] ++;
    }    
    key_buf[0] &= 0x0f;
    key_dat = 0;
    for(x=0;x<1;x++){
        if (key_buf[x] == 0x0f){
            key_dat =key_dat | (1<<x);
        }
    }
    key_ev[0] = key_ev[0] | (~key_old & key_dat);    //  ON edge EVENT set
    key_ev[1] = key_ev[1] | (~key_dat & key_old);    // OFF edge EVENT set
    key_old = key_dat;

    if(mode_10s_t){
        mode_10s_t--;
        if(mode_10s_t == 0){
            timer_ev[0] |= EV_10S;
        }
    }
}

int main()
{
flipper.attach(&flip, 0.001); // the address of the function to be attached (flip) and the interval (2 seconds)
pc.printf("PUSH KEY  \r\nSTART  ");
 
while(1) 
{
    if(mode == 0) 
    {
        if(key_ev[0] & EV_IN)
        {
            pc.printf("\r\n");
            wait(1.0);
            pc.printf("3\r");
            wait(1.0);
            pc.printf("3 2\r");
            wait(1.0);
            pc.printf("3 2 1\r");
            wait(1.0);
            pc.printf(" GO! \r");
            wait(1.0);
            key_ev[0] &= ~EV_IN;
            mode = 1;
            mode_10s_t = MODE_10S;       
        }
    }
    if(mode == 1) 
    {
        if(key_ev[0] & EV_IN)
        {
            c_in++;
            myled = 0;
//                 pc.printf("%2.1f SEC %2d\r",mode_10s_t/100.0,c_in);
            key_ev[0] &= ~EV_IN;
        }
        if((mode_10s_t % 100)==0)pc.printf("%3.1f SEC %2d  \r",mode_10s_t/1000.0,c_in);

        if(key_ev[1] & EV_IN)
        {
            myled = 1;
            key_ev[1] &= ~EV_IN;
        }
    }

    if(mode == 2) 
    {
        myled = 0;
        pc.printf("\r\n\r\n\r\nRESULT=%2.1f\r",c_in/10.0);
        wait(100);
    }
    if(timer_ev[0] & EV_10S)
    {
        timer_ev[0] &= ~EV_10S;
        mode = 2;
    }
}
}
