#include "mbed.h"

DigitalOut led_green(LED1);
DigitalOut led_red(LED2);

InterruptIn user_button(USER_BUTTON);

float delay_on = 0.2;
float delay_off = 1.0;

void button_pressed()
{
    delay_on = 0.1;
    delay_off = 0.1;
}

void button_released()
{
    delay_on = 0.2;
    delay_off = 1.0;
}

int main()
{
    user_button.rise(&button_pressed);
    user_button.fall(&button_released);
    
    while(1) {
        // LEDs are ON
        led_green = 1;
        led_red = 1;
        wait(delay_on);
        // LEDs are OFF
        led_green = 0;
        led_red = 0;
        wait(delay_off);
    }
}