 #include "mbed.h"
 #include "MAG3110.h"
 #include "MMA8451Q.h"
 #include "TSISensor.h"
 //#include "TEMT5200.h"
 
 Serial pc(USBTX, USBRX); // tx, rx
 // Magnetometer
 #define MAG3110_I2C_ADDRESS (0x0e<<1)
 // MAG3110 mag(PTE25, PTE24, MAG3110_I2C_ADDRESS);
 MAG3110 mag(PTE25, PTE24, &pc);
 // Accelerometer
 #define MMA8451_I2C_ADDRESS (0x1d<<1)
 MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
 
 // Slide sensor acts as a button
 TSISensor tsi;
 
 // Ambient light sensor
 // TEMPT5200 alux(PTE22);
 
 
 DigitalOut GreenLED(LED1);
 DigitalOut RedLED(LED2);
 
 void callback() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    printf("%c\n", pc.getc());
    GreenLED = (!GreenLED)|(GreenLED);
    wait(10);
    GreenLED = !GreenLED;
 }
 

void calXY() //magnetometer calibration: finding max and min of X, Y axis
{
    int tempXmax, tempXmin, tempYmax, tempYmin, newX, newY;

    RedLED = 1;

    printf("Waiting for initial press\n");
    // Wait for slider to be pressed
    while( tsi.readDistance() == 0 ) {
        RedLED = 1;
        wait(0.2);
        RedLED =0;
        wait(0.2);
    }

    printf("Waiting for release\n");

    // Wait for release
    while( tsi.readDistance() != 0 ) {
        RedLED =0;
        wait(0.2);
        RedLED = 1;
        wait(0.2);
    }
    RedLED =0;
    wait(0.5);

    printf("Rotate\n");

    tempXmax = tempXmin = mag.readVal(MAG_OUT_X_MSB);
    tempYmax = tempYmin = mag.readVal(MAG_OUT_Y_MSB);

    while(tsi.readDistance() == 0) {
        GreenLED = 1;
        wait(0.1);
        GreenLED =0;
        wait(0.1);
        newX = mag.readVal(MAG_OUT_X_MSB);
        newY = mag.readVal(MAG_OUT_Y_MSB);
        if (newX > tempXmax) tempXmax = newX;
        if (newX < tempXmin) tempXmin = newX;
        if (newY > tempYmax) tempYmax = newY;
        if (newY < tempYmin) tempYmin = newY;
    }
   
    mag.setCalibration( tempXmin, tempXmax, tempYmin, tempYmax );

    // Wait for release
    while( tsi.readDistance() != 0 ) {
        GreenLED =0;
        wait(0.2);
        GreenLED = 1;
        wait(0.2);
    }
    GreenLED =0;
    wait(1.0);

}


 int main(void){
    
    pc.attach(&callback);
    
    // MAG3110 Calibration
    printf("MAG3110 Test\n");

    RedLED =0;
    GreenLED = 1;
    
    // Get some values
    printf("DR_STATUS %X\n", mag.readReg( MAG_DR_STATUS ));
    printf("WHO_AM_I %X\n", mag.readReg( MAG_WHO_AM_I ));
    printf("SYSMOD %X\n", mag.readReg( MAG_SYSMOD ));
    printf("DIE_TEMP %d\n", mag.readReg( MAG_DIE_TEMP ));

    printf("OFF_X %d\n", mag.readVal( MAG_OFF_X_MSB ));
    printf("OFF_Y %d\n", mag.readVal( MAG_OFF_Y_MSB ));
    printf("OFF_Z %d\n", mag.readVal( MAG_OFF_Z_MSB ));

    printf("CTRL_REG1 %X\n", mag.readReg( MAG_CTRL_REG1 ));
    printf("CTRL_REG2 %X\n", mag.readReg( MAG_CTRL_REG2 ));

    printf("calibrate\n");
    calXY();
    printf("....Finished\n");

    RedLED = 0;
    GreenLED = 0;
    
    
    
    
    
    while(1){
        
        wait(0.5);
        int xVal = mag.readVal(MAG_OUT_X_MSB);
        int yVal = mag.readVal(MAG_OUT_Y_MSB);
        int zVal = mag.readVal(MAG_OUT_Z_MSB);
        float heading = mag.getHeading();
       
// Do something with heading - display direction and turn on blue LED if heading approx north
        if (abs(heading) <= 22.5) {
            printf("N\n");
            RedLED = 0;
        } else RedLED = 1;
        
        if (abs(heading) >= 157.5) pc.printf("S\n");
        if (heading >= 67.5 && heading <= 112.5) pc.printf("E \n");
        if (heading <= -67.5 && heading >= -112.5) pc.printf("W \n");
        if (heading > 22.5 && heading < 67.5) pc.printf("NE\n");
        if (heading < -22.5 && heading > -67.5) pc.printf("NW\n");
        if (heading > 112.5 && heading < 157.5) pc.printf("SE\n");
        if (heading < -112.5 && heading > -157.5) pc.printf("SW\n");
        //if (heading < 0) heading += 360.0;
        
        pc.printf("magX = %d, magY = %d, magZ = %d, Heading = %f ;\t", xVal, yVal, zVal, heading);

        pc.printf("accX = %f, accY = %f, accZ = %f;\t", abs(acc.getAccX()),abs(acc.getAccY()),abs(acc.getAccZ()));
                
        pc.printf("Touch Sensor Input: %f\n", tsi.readPercentage());
        
        //pc.printf("Ambient Light: %f", alux);
        wait(1);
        }
    
    
 }