#include "mbed.h"

#include "common.h"
#include "plan-position.h"
#include "patterns.h"

#define moves_z (MAX(draw_z - 0.5, MIN_Z - 0.5))

#define START_TRANS 'B'
#define END_TRANS 0xFFFF1111

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalIn goto_draw_height(p26);
DigitalIn troll_up(p25);
DigitalIn troll_down(p24);
DigitalIn start_pat(p23);

volatile U08 serial_buffer[16];
volatile S32 sbuffer_index;

static F32 draw_z = 9.5; // inches
bool pen_needs_reset = false;

Planner planner;

void serial_callback() {
    serial_buffer[sbuffer_index++] = pc.getc();
}

void setup() {
    sbuffer_index = 0;
    pc.baud(115200);
    pc.attach(serial_callback);

    setup_planner(&planner);

    pc.printf("Setup\r\n");
}

Status wait_for_pattern() {
    while (true) {
        if (planner.finished) {
            return SUCCESS;
        }
        if (planner.errored) {
            pc.printf("FAILURE");
            led2 = 1;
            return FAILURE;
        }
    }
}

Status fill_buffer() {
    int i;
    Point in;
    
    pause_steppers(&planner);
    pc.putc(START_TRANS);
    for (i = 0; i < BUFFER_SIZE - 5; i++) {
        while (sbuffer_index < 9);
        if ((*(U32*)(&serial_buffer[0])) == END_TRANS)
            return END_PAT;
        sbuffer_index = 0;
        pc.putc(START_TRANS);
        
        in.x = *(F32*)(&serial_buffer[0]);
        in.y = *(F32*)(&serial_buffer[4]);
        
        if (serial_buffer[8] == 1)
            in.z = moves_z;
        else
            in.z = draw_z;
        
        add_point_to_buffer(&planner, in);
    }
    resume_steppers(&planner);
    
    return SUCCESS;
}

void adj_z() {
    Point next_pos = planner.current_pos;
    if (troll_up) {
        pc.printf("up\r\n");
        draw_z -= 0.001; 
        next_pos.z = draw_z;
        add_point_to_buffer(&planner, next_pos);
    }
    else if (troll_down) {
        pc.printf("down\r\n");
        draw_z += 0.001; 
        next_pos.z = draw_z;
        add_point_to_buffer(&planner, next_pos);
    }
    else {
        next_pos.z = draw_z;
        add_point_to_buffer(&planner, next_pos);
    }
    wait_for_pattern();
    pen_needs_reset = true;
}

void reset_pen() {
    pc.printf("reset\r\n");
    Point next_pos(0, 0, START_Z); 
    add_point_to_buffer(&planner, next_pos);
    wait_for_pattern();
}

int main() {
    //Status status;
    setup();

    // adjust z
    while (1) {
        if (goto_draw_height) {
            adj_z();
        }
        else if (start_pat) {
            break;
        }
        else if (pen_needs_reset) {
            reset_pen();
            pen_needs_reset = false;
        }
    }
    
    wait_ms(500);
    
    while (true) {
        while (!start_pat);
        pause_steppers(&planner);
        pc.printf("starting pattern\r\n");
        draw_square_large(moves_z, draw_z, &planner);
        resume_steppers(&planner);
        wait_for_pattern();
    }
    
    /*
    while (1) {

        while(1) {
            run_pattern();
            if (go_run_pat)
                break;
        }
        
        status = SUCCESS;
        sbuffer_index = 0;
        while (status == SUCCESS) {
            status = fill_buffer();
            run_pattern();
        }
        pc.putc('D');
    }
    */
}
