#ifndef __NETCENTRICAPP_H__
#define __NETCENTRICAPP_H__

#include "AndroidAccessory.h"
#include "mbed.h"
#include "MbedCommand.h"

#define READ_BUFF   2048
#define WRITE_BUFF  2048

#define NO_ERROR                    0
#define ERR_COMMAND_NOT_FOUND       1

#define COMMAND_ZERO                0
#define COMMAND_ONE                 1
#define COMMAND_TWO                 2
#define COMMAND_THREE               3
#define COMMAND_FOUR                4
#define COMMAND_FIVE                5
#define COMMAND_SIX                 6
#define COMMAND_SEVEN               7
#define COMMAND_EIGHT               8
#define COMMAND_NINE                9
#define COMMAND_TEN                 10
#define COMMAND_LEFT                11
#define COMMAND_RIGHT               12
#define COMMAND_POSITION            13

class NetCentricApp : private AndroidAccessory {
    public:
        NetCentricApp():
            AndroidAccessory(READ_BUFF, WRITE_BUFF,
                                "ARM",
                                "mbed",
                                "mbed - NetCentric",
                                "0.2",
                                "http://www.uva.nl",
                                "0000000012345678")
            {};
        
    protected:
        virtual void setupDevice();
        virtual void resetDevice();
        virtual int callbackRead(u8 *buffer, int len);
        virtual int callbackWrite();
        
        MbedResponse *getResponse(MbedRequest *request);
    
    private:
        static float getFloat(u8 *buffer, int offset, int bufferLen);
        static int getInt(u8 *buffer, int offset, int bufferLen);
        static u8 getUByte(u8 *buffer, int offset, int bufferLen);
        
        MbedResponse *sumCommand(MbedRequest *request);
        MbedResponse *avgCommand(MbedRequest *request);
        MbedResponse *ledCommand(MbedRequest *request);
};

#endif