/*****************************************************************************
* Copyright (c) 2019 Analog Devices, Inc.  
* 
* All rights reserved.
* 
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions are met:
*   - Redistributions of source code must retain the above copyright notice, 
*     this list of conditions and the following disclaimer.
*   - Redistributions in binary form must reproduce the above copyright notice, 
*     this list of conditions and the following disclaimer in the documentation 
*     and/or other materials provided with the distribution.  
*   - Modified versions of the software must be conspicuously marked as such.
*   - This software is licensed solely and exclusively for use with 
*     processors/products manufactured by or for Analog Devices, Inc.
*   - This software may not be combined or merged with other code in any manner 
*     that would cause the software to become subject to terms and 
*     conditions which differ from those listed here.
*   - Neither the name of Analog Devices, Inc. nor the names of its 
*     contributors may be used to endorse or promote products derived 
*     from this software without specific prior written permission.
*   - The use of this software may or may not infringe the patent rights 
*     of one or more patent holders. This license does not release you from 
*     the requirement that you obtain separate licenses from these patent 
*     holders to use this software.
* 
* THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
* NON-INFRINGEMENT, TITLE, MERCHANTABILITY AND FITNESS FOR A 
* PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL ANALOG DEVICES, 
* INC. OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
* SPECIAL, EXEMPLARY, PUNITIVE OR CONSEQUENTIAL DAMAGES 
* (INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF CLAIMS OF 
* INTELLECTUAL PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE 
* GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
* POSSIBILITY OF SUCH DAMAGE.
* 
* 20180927-7CBSD SLA
*****************************************************************************/

/* 
The SDP connector is a 120 pin connector used on Analog Devices controller 
boards to interface with ADI evaluation boards, over 450 ADI evaluation boards 
utilise this connector, a list of these boards can be found at 
https://www.analog.com/en/design-center/evaluation-hardware-and-software/evaluation-development-platforms/sdp.html#Compatible-Boards.

The following is an example program showing how to initialise and use SDP 
connector peripherals (using SPI and GPIOs as an example) on the SDP-K1 in mbed.
Informtion on the pin name definitions for the SDP connector on the SDP-K1 can 
be found at https://os.mbed.com/platforms/SDP_K1/.
The full list of peripherals available on the SDP connector include GPIOs, 
Timers, SPI, I2C, and UART. For further information on how to enable these 
peripherals, consult the mbed documentation https://os.mbed.com/docs/mbed-os/v5.15/apis/drivers.html
*/
#include "mbed.h"
#include "platform/mbed_thread.h"
#include <bitset>
#include "FibonacciLFSR.h"
#include "FastPWM.h"

// Initialise the serial object with TX and RX pins
Serial pc(USBTX, USBRX);

// Initialise the digital pin 5 as a fast PWM output, prescaler set to 1
FastPWM fastpwm(D5,1);
 
 // Initialise LFSR random
FibonacciLFSR lfsr(FibonacciLFSR::LFSR_8);
      
// main() runs in its own thread in the OS
int main()
{   
    uint16_t lfsr_rand1, lfsr_rand2, lfsr_rand3;
    int lfsr_rand_test;
    uint32_t rando = rand();
    
    std::bitset<32> rand_bitset(rando);
    
    //pc.printf("System Core Clock: %d\r\n", SystemCoreClock);  
    //pc.printf("Random Number: %d\r\n", rando); 
       
    while(true){
        
        //fastpwm.period_ticks(4); // fast PWM allows period to be set in ticks of SystemCoreClock. 4 ticks = 45MHz on SDP-K1
        //fastpwm.pulsewidth_ticks(2); // duty cycle 50%
        
        fastpwm.period_ticks(18); // fast PWM allows period to be set in ticks of SystemCoreClock. 4 ticks = 45MHz on SDP-K1
        //fastpwm.pulsewidth_ticks(9);
        // cycle pulse width randomly
        for (int i = 0; i < 32; ++i) {
            if (rand_bitset.test(i))             
                fastpwm.pulsewidth_ticks(9);           
            else
                 fastpwm.pulsewidth_ticks(0);           
        }       
    }
}

