#include "mbed.h"
#include "MPU6050.h"
//creating an object of serial class so that we can communicate with PC
Serial pc(SERIAL_TX, SERIAL_RX);

MPU6050 ark(PA_10,PA_9); //creating onject of MPU6050 class
int main()
{
    while(1) {
        float temp = ark.getTemp();
        float dataString[7];
        float gyro[3];
        ark.getGyro(gyro);
        float acce[3];
        ark.getAccelero(acce);
        
        dataString[0] = temp;
        dataString[1] = gyro[0];
        dataString[2] = gyro[1];
        dataString[3] = gyro[2];
        dataString[4] = acce[0];
        dataString[5] = acce[1];
        dataString[6] = acce[2];
        
        pc.printf("#"); //Initial character for encoding
        for(int i = 0; i<7; i++) {
            pc.printf("%0.2f",dataString[i]);
            pc.printf("^"); // character to seprate data
        }
        pc.printf("$"); //lat character of string for encoding
        pc.printf("\n");
        wait(1); //wait 1000ms
    }
}