#include "mbed.h"

DigitalOut redLed(p21); 
DigitalIn pb(p8); // Pushbutton for redLed
DigitalOut led1(LED1);
DigitalOut led3(LED3);

void kick() {
    LPC_WDT->WDFEED = 0xAA;
    LPC_WDT->WDFEED = 0x55;
}

void kick(float s) {
    LPC_WDT -> WDCLKSEL = 0x1;
    uint32_t clk = SystemCoreClock/16;
    LPC_WDT->WDTC = s * (float)clk;
    LPC_WDT->WDMOD = 0x3;
    kick();
}



int main() {
    int count = 0;
    // Use internal pullup for pushbutton
    pb.mode(PullUp);
    
    // Delay for initial pullup to take effect
    wait(.001);

    // Indicate watchdog timer reset 
    if((LPC_WDT->WDMOD >> 2) & 1) {
        led1 = 1;
    } 
    
    kick(5); // 5 second timeout
    while(1) {
        redLed = !pb;
        led3 = 1;
        // Simulate a fault lockup with infinite loop after a bunch of iterations
        if (count == 1000000) {
            while(1){
            
            }
        }
        led3 = 0; // led will stay on during fault
        count++;
        kick();            
    }
}