#include "mbed.h"
#include "arm.h"

Arm arm(p9,p10);
//Motor 1
DigitalIn button1open(p20);
DigitalIn button1close(p21);
//Motor 2
DigitalIn button2left(p19);
DigitalIn button2right(p22);
//Motor 3
DigitalIn button3up(p18);
DigitalIn button3down(p23);
//Motor 4
DigitalIn button4up(p17);
DigitalIn button4down(p24);
//Motor 5
DigitalIn button5up(p16);
DigitalIn button5down(p25);
//Motor 6
DigitalIn button6left(p15);
DigitalIn button6right(p26);

InterruptIn throwButton(p27);

void initialPos();
void throwMode();
void move(int16_t motorNumber, bool switch1, bool switch2, 
            int16_t * motor, 
            int16_t max_pos, int16_t min_pos, int16_t mov);

int16_t motor2=125, motor3=500, motor4=500, motor5=500, motor6=500;

int main(){
    throwButton.rise(&throwMode);
    initialPos();
    
    while(1){
        
        if(button1open)
            arm.moveServo(1,500,700);
        else if(button1close)
            arm.moveServo(1,0,700);
        
        //motor 2       
        move(2,button2left,button2right,
                &motor2, 
                1000, 0, 25);
        
        //motor 3        
        move(3,button3up,button3down,
                &motor3, 
                1000, 0, 25);
            
        //motor 4        
        move(4, button4down, button4up,
                &motor4, 
                1000, 0, 25);
        
        //motor 5        
        move(5,button5up,button5down,
                &motor5, 
                1000, 0, 25);
        //motor 6
        move(6,button6left,button6right,
                &motor6, 
                1000, 200, 25);
                
        wait(0.1);
    }       
    
}

void move(int16_t motorNumber, bool switch1, bool switch2, 
            int16_t * motor, 
            int16_t max_pos, int16_t min_pos, int16_t mov){
                
    int16_t prev = *motor;
    if(switch1)
            *motor = ((*motor-mov) >= min_pos) ? *motor-mov : min_pos;
    else if(switch2)
        *motor = ((*motor+mov) <= max_pos) ? *motor+mov : max_pos;
    if (prev!=*motor)
            arm.moveServo(motorNumber,*motor,100);
}

void throwMode(){
    
    bool active = true;
    
    //Throw possition
    arm.moveServo(2,125,500);
    arm.moveServo(3,700,1000);
    arm.moveServo(4,350,1000);
    arm.moveServo(5,700,1000);
    arm.moveServo(6,500,1000);
    
    while(active){
        if(button1open)
            arm.moveServo(1,500,700);
        else if(button1close)
            arm.moveServo(1,0,700);
        
        if(button2left || button2right){
            motor2=125, motor3=450, motor4=600, motor5=500, motor6=500;
            
            //Throw function
            arm.moveServo(3,motor3,300);
            arm.moveServo(4,motor4,300);
            arm.moveServo(5,motor6,300);
            wait(0.13);
            arm.moveServo(1,0,200);
            
            active=false;
            
        } 
    }
}

void initialPos(){
    arm.moveServo(1,500,1000);
    arm.moveServo(2,125,500);
    arm.moveServo(3,500,1000);
    arm.moveServo(4,500,1000);
    arm.moveServo(5,500,1000);
    arm.moveServo(6,500,1000);
}
