#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "sansSerif19x20.h"
#include "DHT.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "HTTPClient.h"
#include "picojson.h"
#include "SDFileSystem.h" 
#include <MbedJSONValue.h>
#include <string>
#include "StepperMotor_X27168.h"
//IMPORTANT YOU NEED TO SET THE API KEY for thingspeak look for "your key here"
//TAKE CARE URL doesn't excced buffer size 
//sd card
// SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); // MOSI, MISO, SCLK, SSEL
//Ethernet Interface 

DigitalOut communicate(p30);   ///Pull low until ready to go
DigitalOut motor3(p23);
StepperMotor_X27168 smotor3(p24,p25,p22,p21);


EthernetInterface eth;
//NTP service for date and Time used to set boards RTC
NTPClient ntp;
//HTTP Client for interfacing to web services
HTTPClient http;
//char resp[1024]; //buffer for the responce
//On board LED
//DigitalOut myled(LED_GREEN);
//serial over USB for debug and Info
Serial pc(USBTX, USBRX);
std::string resp;
//temperature sensor
//DHT sensor(PTB18,DHT22); // there are several libraries available, this reports CRC error sometimes 
//320x240 Display ILI9341 controller (look on ebay)
//SPI_TFT_ILI9341 TFT(PTD2, PTD3, PTD1,PTC3 ,PTC4 ,PTD0  ,"TFT"); // mosi, miso, sclk, cs, reset, dc

MbedJSONValue v;

volatile char   c = '\0'; // Initialized to the NULL character
volatile int check = 0;
Serial device(p28,p27); //9-10 11u;    28-27 1768
void onCharReceived()
{
    c = device.getc();
    check = 1;
}

int main()
{
    communicate = 0;
    pc.printf("\r\nWeather Reporter\n");
    
//    while (1) {
//        wait(.1);
//        }
//    check = 0;
    
//    device.attach(&onCharReceived);
    
    

    int ret=0;

    //used to parse the json data
//    picojson::value v;
//    char * json;
    std::string json;
    HTTPMap map;

    pc.printf("\r\nWeather Reporter\n");

    



    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("IP Address is %s\r\n", eth.getIPAddress());
    std::string mac;
    mac = eth.getMACAddress();
    pc.printf("MAC: %s\r\n", mac);
    TCPSocketConnection sock;
    
    sock.connect("api.openweathermap.org", 80);
    wait(5);
    char http_cmd[] = "GET /data/2.5/weather?q=Atlanta,US&APPID=a1c3afc7f18b7ef578cef48d5163cda6 HTTP/1.0\r\n\r\n";
    if (!sock.is_connected()){
        pc.printf("This not working");
        return -1;
        }
    sock.send_all(http_cmd, sizeof(http_cmd)-1);
    char buffer[1000];
    //int ret;
    while (true) {
        ret = sock.receive(buffer, sizeof(buffer)-1);
        if (ret <= 0)
            break;
        buffer[ret] = '\0';
        pc.printf("Received %d chars from server:\n%s\n", ret, buffer);
    }
      
    sock.close();
    
    eth.disconnect();
    
   
    float forecastHumidity=0;
//    float temperature=-100;
    float forcastTemp=0;
    float forcastDescription = 0;
//    float forcastPressure;
    wait(2);
    pc.printf("\r\nDHT Test program");
    pc.printf("\r\n******************\r\n");
    wait(1); // wait 1 second for device stable status
    char cstr[resp.size() + 1];
    while(1){
        
        //GET forcast data
        pc.printf("\nTrying to fetch page...\n");
        //try getting the weather, 5 second timeout     
//        HTTPResult r = http.get("http://api.openweathermap.org/data/2.5/weather?q=Atlanta,US&APPID=a1c3afc7f18b7ef578cef48d5163cda6", resp, 5000);
//        HTTPResult r = http.get("www.google.com", resp, 4096, 20000);
//      ret = http.get("http://api.openweathermap.org/data/2.5/find?q=London",resp, 15000);
        if(!ret){
          std::string b2s(buffer, 1000);
          int i =  b2s.find("\r\n\r\n",0);
          resp.assign(buffer+i+4);
          pc.printf("responce=%s",resp);
          strcpy(cstr, resp.c_str());
            int len = strlen(cstr);
            cstr[5] = '\n';
//          json = NULL;    
          //char * result = NULL;
//          asprintf(&result, "%s%s", json, "NULL");
//          std::string sJson(json);
//          pc.printf("parsing");
//          const  char * json = "{\"my_array\": [\"demo_string\", 10], \"my_boolean\": true}";
 
            //parse the previous string and fill the object demo
            std::string newline= "\n";
            resp.append(newline);
            
            
            
//            std::string error = parse(v, cstr);
            json = cstr;
            struct weatherData{
                std::string temp;
                std::string desc;
                std::string hum;
            };
            
                int beg, end;
                weatherData weather;
                //first find description
                beg = json.find("description") + 14;
                end = json.find("," , beg) - 1;
                weather.desc = json.substr(beg,end-beg);
                //next find temperature
                beg = json.find("temp", end) + 6;
                end = json.find("," , beg); 
                weather.temp = json.substr(beg,end-beg);;
                //last find humidity
                beg = json.find("humidity", end) + 10;
                end = json.find(",", beg); 
                weather.hum = json.substr(beg,end-beg);
//                
//                pc.printf("humidity: %s", weather.hum);
//                pc.printf("temp: %s", weather.temp);
//                pc.printf("desc: %s", weather.desc);
            
           // get time
           std::time_t t = std::time(0);
            std::time_t result = time(NULL);
//            std::cout << std::asctime(std::localtime(&result))



   //     pc.printf("\n\nCurrent Time:  %s \r\n",ctime(&result));
    //    pc.printf("Current Temperature:  %s Kelvin \r\n",weather.temp);
   //     pc.printf("Humidity is %s \r\n",weather.hum);
 //       pc.printf("Weather Condition: %s  \r\n", weather.desc);
  //      
        double weather_temp = atof(weather.temp.c_str());
        //double weather_temp = 301.483;
        weather_temp = weather_temp - 273.15;
        weather_temp = (weather_temp * 9/5) + 32;
        // range is 60 - 85
        weather_temp = weather_temp - 60;
        weather_temp = weather_temp * 360/25;
        
        wait(5);
        motor3 = 1;
        smotor3.step_position(weather_temp);
        wait(1.5);
        communicate = 1;
   
    
    wait(60);
  }      

}}
