#include "PulseManager.h"

PulseManager::PulseManager(PinName trigger, PinName echo):
        startval(0), pulsetime(), runtime(), trigger(trigger), echo(echo)    {}


PulseManager::~PulseManager() {}

void PulseManager::write(int val) {
    trigger = val;
}

void PulseManager::write_us(int val, int time)   {
    // Write the complement of the high/low signal for a clean desired signal
    trigger = !val;
    wait_us(4);
    
    // Now write the desired signal for the given amount of time in us
    trigger = val;
    wait_us(time);
    
    // Write the complement again to end the signal write
    trigger = !val;
}

int PulseManager::read_us()  {
    // Reset the pulse timer
    pulsetime.reset();
    
    // Wait for edge
    startval = echo;
    while (echo == startval)   {}
    
    // Measure pulse width
    pulsetime.start();
    while (echo != startval)  {}
    pulsetime.stop();
    
    return pulsetime.read_us();
}

int PulseManager::read_us(int timeout)   {
    // Reset timers, start runtime timer to detect timeout
    runtime.reset();
    runtime.start();
    pulsetime.reset();
    
    // Wait for edge
    startval = echo;
    while (echo == startval)  {
        if (runtime.read_us() > timeout)   return -1;
    }
    
    // Measure pulse width
    pulsetime.start();
    while (echo != startval)   {
        if (runtime.read_us() > timeout)   return -1;
    }
    pulsetime.stop();
    
    return pulsetime.read_us();
}

int PulseManager::read_high_us()  {
    // Reset timer
    pulsetime.reset();
    
    // Wait for next edge of echo signal
    while (echo == 1) {}
    while (echo == 0) {}
    
    // Measure pulse width of the echo pulse
    pulsetime.start();
    while (echo == 1) {}
    pulsetime.stop();
    
    return pulsetime.read_us();
}

int PulseManager::read_high_us(int timeout)  {
    // Reset runtime timer for timeout detection
    runtime.reset();
    runtime.start();
    
    // Reset pulseTimer
    pulsetime.reset();
    
    // Wait for next edge of echo signal
    while (echo == 1) {
        if (runtime.read_us() > timeout)   return -1;
    }
    while (echo == 0) {
        if (runtime.read_us() > timeout)   return -1;
    }
    
    // Measure pulse width of the echo pulse
    pulsetime.start();
    while (echo == 1) {
        if (runtime.read_us() > timeout)   return -1;    
    }
    pulsetime.stop();
    
    return pulsetime.read_us();
}

int PulseManager::read_low_us()   {
    // Wait for next edge of echo signal
    while (echo == 0) {
    }
    while (echo == 1) {
    }
    
    // Measure pulse width of the echo pulse
    pulsetime.start();
    while (echo == 0) {}
    pulsetime.stop();
    
    return pulsetime.read_us();
}

int PulseManager::read_low_us(int timeout)   {
    // Reset runtime timer for timeout detection
    runtime.reset();
    runtime.start();
    
    // Wait for next edge of echo signal
    while (echo == 0) {
        if (runtime.read_us() > timeout)   return -1;
    }
    while (echo == 1) {
        if (runtime.read_us() > timeout)   return -1;
    }
    
    // Measure pulse width of the echo pulse
    pulsetime.start();
    while (echo == 0) {
        if (runtime.read_us() > timeout)   return -1;    
    }
    pulsetime.stop();
    
    return pulsetime.read_us();
}
