#ifndef MBED_HCSR04_H
#define MBED_HCSR04_H

#include "PulseManager.h"

class HCSR04   {
    public:
        /** 
        * Create a HCSR04 object
        * @param triggerPin Digital I/O pin to use for sending the trigger pulse
        * @param echoPin    Digital I/O pin to use for measuring the width of the echo pulse
        * @param timeout    Time to wait for a pulse before giving up.
        */
        HCSR04(PinName triggerPin, PinName echoPin, int timeout);
        
        /** Destructor to free allocated memory */
        ~HCSR04();

        /** Return distance to nearest object in inches, or -1.0 if the reading of the pulse times out */
        float getReadingInches();
        
        /** Return distance to nearest object in centimeters, or -1.0 if the reading of the pulse times out */
        float getReadingCm();
        
        /** Constant scaling for converting distance readings to inches */
        static const int SCALE_INCHES = 148;
        
        /** Constant scaling for converting distance readings to inches */
        static const int SCALE_CM = 58;
        
    private:

        /** Pulse manager for sending/measuring pulses */
        PulseManager* pulseManager;
        
        /** Timeout limit in us */
        int timeout;
        
        /** Use the pulse manager to get a distance reading */
        float getReading();
};

#endif