#include "HCSR04.h"

HCSR04::HCSR04(PinName triggerPin, PinName echoPin, int time)
    : timeout(time)  {
        pulseManager = new PulseManager(triggerPin, echoPin);
}

HCSR04::~HCSR04() {
    delete pulseManager;
}

float HCSR04::getReading() {
    // Send the trigger pulse (high signal for 8 us)
    pulseManager->write_us(1, 6);
    
    // Report the width of the echo pulse
    return (float) pulseManager->read_high_us(timeout);
}

float HCSR04::getReadingInches() {
    // Acquire the width of the echo pulse
    float distance = getReading();
    
    // Return calculated distance in cm's. or -1.0 if the measurement is bad
    return (distance == -1.0 ? -1.0 : distance / SCALE_INCHES);
}

float HCSR04::getReadingCm() {
    // Acquire the width of the echo pulse
    float distance = getReading();
    
    // Return calculated distance in cm's. or -1.0 if the measurement is bad
    return (distance == -1.0 ? -1.0 : distance / SCALE_CM);
}
