/***    受信したデータをSDに保存して確認するプログラム    */

#include "mbed.h"
#include "IM920.h"
#include "SDFileSystem.h"

// Pin used by SD card 
SDFileSystem sd(p5, p6, p7, p8, "sd"); 

// Pin used by IM920 & UART
Serial pc(USBTX, USBRX);
IM920 im920(p28, p27, p29, p30);

//Digital I/O Pin
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
AnalogIn inpt(p20);

//Prottype define
void SD(int num, double btry);
void callback(void);

//Define maclo
char BUF[65];

int main() {
    float btry_lg = 0;
    int nmbr_lg = 0;
    
    FILE *fp_csv = fopen("/sd/mydir/sdtest.csv", "w");
    if(fp_csv == NULL) {
        error("Could not open file for write\n");
    }
    fprintf(fp_csv, "baterry,number\n");
    fclose(fp_csv); 
    
    
//    FILE *fp_txt = fopen("/sd/mydir/sdtest.txt", "a");
//    if(fp_txt == NULL) {
//        error("Could not open file for write\n");
//    }
//    fclose(fp_txt); 
      
    while(1){
        // test the voltage on the initialized analog pin
        //  and if greater than 0.3 * VCC set the digital pin
        //  to a logic 1 otherwise a logic 0
        btry_lg = inpt.read()*3.3;
        
        //if(ain > 0.3f) {
            
        //} else {
            
        //}
        
        // print the percentage and 16 bit normalized values
        //printf("percentage: %3.3f%%\n", ain.read()*100.0f);
        //printf("normalized: 0x%04X \n", ain.read_u16());
        //wait(0.2f);
        
        
        
        nmbr_lg++;
        SD(nmbr_lg, btry_lg);
          
        //wait(0.1);
    }
}

void SD(int num, double btry){
    myled1 = 1;
    
    //printf("Hello World!\n");   
 
    mkdir("/sd/mydir", 0777);
    
    FILE *fp_csv = fopen("/sd/mydir/sdtest.csv", "a");
    if(fp_csv == NULL) {
        error("Could not open file for write\n");
    }
    
    fprintf(fp_csv, "%d,%f\n",num, btry);
    
    fclose(fp_csv); 
    
    /***    txtファイルバージョン    ***/
    
//    FILE *fp_txt = fopen("/sd/mydir/sdtest.txt", "a");
//    if(fp_txt == NULL) {
//        error("Could not open file for write\n");
//    }
//    fprintf(fp_txt, "Hello fun SD Card World!\n");
//    fprintf(fp_txt, "Hello fun SD Card World!\n");
//    fprintf(fp_txt, "%f,%f\n", btry, (float)num);
//    
//    fclose(fp_txt); 
    
    
    printf("Goodbye World!\n");
    myled1 = 0;
}

void callback(void){
    int i;
    char buf[65];

    i = im920.recv(buf, 64);
    buf[i] = 0;
    printf("recv: '%s' (%d)\r\n", buf, i);
}

void IM920_read(void){
    int i = 0;

    //pc.baud(115200);
    pc.band(19200);
    pc.printf("*** IM920\r\n");
    im920.init();
    im920.attach(callback);
    myled2 = 1;

    im920.poll();
    if (pc.readable()) {
        char c = pc.getc();
        
        if (c == '\r') {
            BUF[i] = 0;
            printf("send: %s\r\n", BUF);
            im920.send(BUF, i);
        }
        else{
            for (i = 0; i < 64; i++) {
                BUF[i] = c;
            }    
    }    
}