#include "mbed.h"

Serial pc(USBTX,USBRX); // do not need when we aren't communicating with pc
DigitalOut myled1(LED1); //LEDs 1 and 2
DigitalOut myled2(LED2);
DigitalIn button(p17); // button attached to p17
Timer led2timer; // create timer

int main() {

int currentstate=0; // set variables as integers
int previousstate=0;
int counter=0;

led2timer.start(); // starts timer

    while(1) {
        
        currentstate=button.read(); // set current state
        
        if (currentstate==1){ // button pressed
            if (led2timer.read()>=1){ // blinks 1s interval when pressed
                myled2=!myled2;
                led2timer.reset(); // reset timer
                }
            
            if (currentstate==previousstate){ // no change
                }
                
            else{ // change in state adds counter
                counter=counter+1;
                pc.printf("count=%i \r\n",counter);
                }
                
            } // if
            
        else { // button released
            if (led2timer.read()>=0.3){ // blinks 0.3s interval when released
                myled2=!myled2;
                led2timer.reset(); // reset timer
                }
            
            if (currentstate==previousstate){ // no change
                }
                
            else{ // change in state adds counter
                counter=counter+1;
                pc.printf("count=%i \r\n",counter);
                }
            
            } // else
        
        if (counter==10){ // counter reaches 10 turns on led1
            myled1=1;
            } // if
        
        previousstate=currentstate; //set previous state at loop end
        
        wait(0.1); // prevents the counter from counting switch bounces
                   // wait is ok because it it shorter than the timer 0.3
        
    } // while
    
} // main
