/* Copyright (c) 2012 Anthony Barison, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
/*
This simple program is written has an example to show how pins of
mbed board can be programmed without the high-level abstraction of the
class DigitalOut.

References:
    http://www.nxp.com/documents/user_manual/UM10360.pdf

Author: Anthony Barison
First release on:   30/08/2012
Last release on: 30/08/2012
*/

#include <stdio.h>

/* pin 20 on the mbed board is memory mapped to port P1.31 of LPC1768
which I have defined as preprocessor directive. The value can be used as a mask to
read and write the status of "p20" */

#define PIN_20 0x80000000        /* this is the mask to be used in referring to p20 on the mbed board */

#define FIO1DIR     (*((volatile unsigned int *) 0x2009C020))       /* output enable register */
#define FIO1CLR		(*((volatile unsigned int *) 0x2009C03C))       /* clear output data register */
#define FIO1SET		(*((volatile unsigned int *) 0x2009C038))       /* set output data register */

//volatile unsigned int *ClearOutputDataReg = (unsigned int *)0xfffff434;

int main()
{
    int state = 0;      /* state variable used as store of user input */

    /* p20 initialization */
    FIO1DIR = PIN_20;   /* enable p20 as an output pin */
    FIO1CLR = PIN_20;   /* set 0 to p20 as a default value */

    printf( "\r\nGPIO\r\nPossible inputs\r\n" );
    printf( "0\tset p20 to 0\r\n" );
    printf( "1\tset p20 to 0\r\n" );
    printf( "-1\tterminate program\r\n\r\n" );


    while(1) {


        /* read user input from terminal */
        printf( "State = ");
        scanf( "%i", &state );
        printf( "%i\r\n", state);


        /* */
        if( state == 0 )
            FIO1CLR = PIN_20;   /* p20 = 2 */
        else if (state == 1)
            FIO1SET = PIN_20;   /* p20 = 1 */
        else if (state == -1)
            return 0;           /* terminate program */
        else
            continue;
    }
}
