         //*** LAB4A ***
/***********************************************************************************************
    File Name:  ELNC6007ARLab4A.c
    Author:     ARAVICHANDRAN
    Date:       30/03/2020
    Modified:   None
    © Fanshawe College, 2016

    Description: The program displays a command sentence when the limit is changed by pressing
                  a push button .
***********************************************************************************************/
// Preprocessor ===================================================================

#include "mbed.h"
#include <stdio.h>

Serial pc(USBTX, USBRX);

// Constants ======================================================================

#define TRUE            1
#define FALSE           0

#define TEMPERATURE     0
#define PRESSURE        1
#define CO2             2
#define NUM             3
#define ADDSIZE         30
#define SAMPLE          30
#define CONTROLLER      1
#define FVS             192

DigitalIn CHAN(p21);
DigitalIn MODE(p22);
DigitalIn INC(p23);
DigitalIn DEC(p24);
Timer timer;

// Global Variables ===============================================================

typedef struct sensorChannel
{
    int currentSample;
    int avgSample;
    int samples[SAMPLE];
    int highLimit;
    int lowLimit;
    unsigned int insertAt;
    unsigned int state; 
} sensorCh_t;

typedef struct motor
{
    char position;
    char currentPosition;
    char pattern;
    char patternCount;
}motorDt_t;

typedef struct fermentVatSys
{
    int fvsAdress[ADDSIZE];
    sensorCh_t sens[NUM];
    motorDt_t motor1;
    motorDt_t motor2;
    int indicator;
    int heater;
    int modeSel;
    int chanSel;
} fvs_t;
fvs_t fvs912;

int temp=0;
int press=0;
int co2=0;
char sentenceRdy=0;
char buffer[SAMPLE]={0};
char counter=0;

// Functions ======================================================================

/*** FVS Initialise ***********************************************************
Author:     ARAVICHANDRAN
Date:       30/03/2020
Modified:   None
Desc:       initialization of data structure members
Input:      None
Returns:    None
**********************************************************************************/
void initializeFvs(void)
{
    fvs912.sens[TEMPERATURE].currentSample=0;
    fvs912.sens[PRESSURE].currentSample=0;
    fvs912.sens[CO2].currentSample=0;
    fvs912.sens[TEMPERATURE].avgSample=0;
    fvs912.sens[PRESSURE].avgSample=0;
    fvs912.sens[CO2].avgSample=0;
    fvs912.sens[TEMPERATURE].insertAt=0;
    fvs912.sens[PRESSURE].insertAt=0;
    fvs912.sens[CO2].insertAt=0;
    fvs912.sens[TEMPERATURE].highLimit=65;
    fvs912.sens[TEMPERATURE].lowLimit=12;
    fvs912.sens[PRESSURE].highLimit=103;
    fvs912.sens[PRESSURE].lowLimit=17;
    fvs912.sens[CO2].highLimit=1200;
    fvs912.sens[CO2].lowLimit=350;
    fvs912.indicator=FALSE;
    fvs912.heater=FALSE;
    fvs912.modeSel=0;
    fvs912.chanSel=0;
    fvs912.motor1.position=357;
    fvs912.motor1.currentPosition=0;
    fvs912.motor1.patternCount=0;
    fvs912.motor2.position=30;
    fvs912.motor2.currentPosition=0;
    fvs912.motor2.patternCount=0;
    
    
}  // eo initializeFvs

/*** calcCheckSum ***********************************************************
Author:     ARAVICHANDRAN
Date:       30/03/2020 
Modified:   None
Desc:       Calculates the check sum
Input:      None
Returns:    None
**********************************************************************************/

char calcCheckSum()
{
    
    char cs=12;
    while(cs<fvs912.sens[TEMPERATURE].currentSample)
    {
        cs*=.5;
        cs*=fvs912.sens[PRESSURE].currentSample;
    }
    return cs;
    
}
// eo calcCheckSum::***************************************************************

/*** generateSentence ***********************************************************
Author:     ARAVICHANDRAN
Date:       30/03/2020 
Modified:   None
Desc:       Sentence is stored in temporary buffer
Input:      None
Returns:    None
**********************************************************************************/

void generateSentence(int newV)
{
    
    sprintf(buffer,"$CONLIM, %i, %i, %i,%i,%i",  CONTROLLER, FVS, fvs912.chanSel, fvs912.modeSel, newV);
    sprintf(buffer, "%s, %i#\0", buffer, calcCheckSum());
    sentenceRdy=1;
    
}// eo generateSentence

/*** chanSel: ********************************************************************
Author:     ARAVICHANDRAN
Date:       30/03/2020
Modified:   None
Desc:       Selects the particular channel
Input:      None
Returns:    None
**********************************************************************************/
void chanSel(void)
{
    fvs912.chanSel++;
    if(fvs912.chanSel>2)
    {
        fvs912.chanSel=0;
    }
}
// eo chanSel:: ******************************************************************

/*** modeSel: ********************************************************************
Author:     ARAVICHANDRAN
Date:       30/03/2020
Modified:   None
Desc:       Mode select function to toggle between the modes
Input:      None
Returns:    None
**********************************************************************************/
void modeSel(void)
{
    fvs912.modeSel=!fvs912.modeSel;
}
// eo modeSel:: ******************************************************************

/*** increment: ********************************************************************
Author:     ARAVICHANDRAN
Date:       30/03/2020
Modified:   None
Desc:       Increment function to increment the limits
Input:      None
Returns:    None
**********************************************************************************/
void increment(void)
{
    if(fvs912.modeSel==1)
    {
        if(fvs912.chanSel==TEMPERATURE)
        {
            fvs912.sens[TEMPERATURE].highLimit++;
            generateSentence(fvs912.sens[TEMPERATURE].highLimit);
        }   
        if(fvs912.chanSel==PRESSURE)
        {
            fvs912.sens[PRESSURE].highLimit++;
            generateSentence(fvs912.sens[PRESSURE].highLimit);
        }
        if(fvs912.chanSel==CO2)
        {
            fvs912.sens[CO2].highLimit++;
            generateSentence(fvs912.sens[CO2].highLimit);
        }
    }
    else if(fvs912.modeSel==0)
    {
        if(fvs912.chanSel==TEMPERATURE)
        {
            fvs912.sens[TEMPERATURE].lowLimit++;
            generateSentence(fvs912.sens[TEMPERATURE].lowLimit);
        }
        if(fvs912.chanSel==PRESSURE)
        {
            fvs912.sens[PRESSURE].lowLimit++;
            generateSentence(fvs912.sens[PRESSURE].lowLimit);
        }
        if(fvs912.chanSel==CO2)
        {
            fvs912.sens[CO2].lowLimit++;
            generateSentence(fvs912.sens[CO2].lowLimit);
        }
    }
}//eo increment:: ******************************************************************

/*** decrement: ********************************************************************
Author:     NRaghuraj
Date:       8 Feb, 2020
Modified:   None
Desc:       Decrement function to decrement the limits
Input:      None
Returns:    None
**********************************************************************************/
void decrement(void)
{
    if(fvs912.modeSel==1)
    {
        if(fvs912.chanSel==TEMPERATURE)
        {
            fvs912.sens[TEMPERATURE].highLimit--;
            generateSentence(fvs912.sens[TEMPERATURE].highLimit);
        }   
        if(fvs912.chanSel==PRESSURE)
        {
            fvs912.sens[PRESSURE].highLimit--;
            generateSentence(fvs912.sens[PRESSURE].highLimit);
        }
        if(fvs912.chanSel==CO2)
        {
            fvs912.sens[CO2].highLimit--;
            generateSentence(fvs912.sens[CO2].highLimit);
        }
    }
    else if(fvs912.modeSel==0)
    {
        if(fvs912.chanSel==TEMPERATURE)
        {
            fvs912.sens[TEMPERATURE].lowLimit--;
            generateSentence(fvs912.sens[TEMPERATURE].lowLimit);
        }
        if(fvs912.chanSel==PRESSURE)
        {
            fvs912.sens[PRESSURE].lowLimit--;
            generateSentence(fvs912.sens[PRESSURE].lowLimit);
        }
        if(fvs912.chanSel==CO2)
        {
            fvs912.sens[CO2].lowLimit--;
            generateSentence(fvs912.sens[CO2].lowLimit);
        }
    }
}//eo decrement:: ******************************************************************

/*** pbFunc: ********************************************************************
Author:     ARAVICHANDRAN
Date:       30/03/2020
Modified:   None
Desc:       Push button operation for required function to perform
Input:      None
Returns:    None
**********************************************************************************/
void pbFunc(void)
{
    if(CHAN==FALSE)
    {
        chanSel();
    }
    if(MODE==FALSE)
    {
        modeSel();
    }
    if(INC==FALSE)
    {
        increment();
    }
    if(DEC==FALSE)
    {
        decrement();
    }
}// eo pbFunc:: ******************************************************************

/*** displayfunc: **************************************************************
Author:     ARAVICHANDRAN
Date:       30/03/2020
Modified:   NRaghuraj
Desc:       This function displays the required functions performed
Input:      None
Returns:    None
**********************************************************************************/
void displayFunc(void)
{
    printf("\033[2J\033[0;0H\n FVS912 System Properties");
    printf("\033[11;0H\n Position: \t%i%c\t\tPosition: \t%i%c", fvs912.motor1.currentPosition, 248, fvs912.motor2.currentPosition, 248);
    printf("\033[5;0H\n Average value:\t%d%cC \t\t Average value:\t%dkPa \t\t\t Average value:\t%dppm", fvs912.sens[TEMPERATURE].avgSample ,248, fvs912.sens[PRESSURE].avgSample , fvs912.sens[CO2].avgSample);
    printf("\033[6;0H\n High Limit: \t%i%cC \t\t High limit: \t%dkPA   \t\t High Limit: \t%dppm",fvs912.sens[TEMPERATURE].highLimit,248,fvs912.sens[PRESSURE].highLimit, fvs912.sens[CO2].highLimit) ;
    printf("\033[7;0H\n Low Limit: \t%d%cC \t\t Low limit: \t%dkPA \t\t\t Low Limit: \t%dppm",fvs912.sens[TEMPERATURE].lowLimit,248,fvs912.sens[PRESSURE].lowLimit, fvs912.sens[CO2].lowLimit) ;
    
    if(fvs912.chanSel==0 )
    {
        printf("\033[2;0H\n Channel Selected: Pressure ");
    }
    else if(fvs912.chanSel==1)
    {
        printf("\033[2;0H\n Channel Selected: Temperature ");
    }
    else if(fvs912.chanSel==2)
    {
        printf("\033[2;0H\n Channel Selected: CO2 ");
    }
    
    if(fvs912.modeSel!=0)
    {
        printf("\033[2;0H\n \t\t\t\t Mode: High");
    }
    else
    {
        printf("\033[2;0H\n \t\t\t\t Mode: Low");
    }
    
    printf("\033[4;0H\n Temperature\t\t\t Pressure\t\t\t\t CO2");
    if(temp> fvs912.sens[TEMPERATURE].highLimit||press>fvs912.sens[PRESSURE].highLimit)
    {
        printf("\033[10;0H\nMotor1: \tDischarge");
    }
    else
    {
        printf("\033[10;0H\n Motor1: \tCharge");
    }
    if(co2> fvs912.sens[CO2].highLimit)
    {
        printf("\033[10;0H\n\t\t\t\tMotor2: \tDampener");
    }
    else
    {
        printf("\033[10;0H\n\t\t\t\tMotor2: \tClosed");
    }

    if(temp> fvs912.sens[TEMPERATURE].highLimit||press>fvs912.sens[PRESSURE].highLimit)
    {
        printf("\033[12;0H\n Control: \tRun");
    }
    else
    {
        printf("\033[12;0H\n Control: \tStop");
    }
    
    if(co2>fvs912.sens[CO2].highLimit)
    {
        printf("\033[12;0H\n \t\t\t\tControl: \t0");
    }
    else
    {
        printf("\033[12;0H\n \t\t\t\tControl: \t0");
    }
        printf("\033[13;0H\n Data: \t\t0 \t\tData: \t\t0");
    
        while(sentenceRdy)
        {
        if(counter< 70)
        {
            printf("\033[15;0H\n %s", buffer);
            counter++;
        }
        else
        {
            printf("\033[15;0H                     ");
            sentenceRdy=0;    
        }     
    } 
}//eo displayFunc

/*******************************************************************************
*****MAIN FUNCTION**************************************************************
*******************************************************************************/
int main()
{
    pc.baud(9600);      //sets baudrate to 9600
    initializeFvs();    
    timer.start();      //timer starts 
    while (true) 
    {
        pbFunc();   
        if(counter<=4)
        {
            counter++;
            displayFunc();  
        }
        else
        {
            counter=0;
            timer.reset();  
        }
    }
}
 