#include "mbed.h"
 
#define TMP102_REG_TEMP (0x00) // Temperature Register
#define TMP102_REG_CONF (0x01) // Configuration Register
#define TMP102_ADDR     (0x90) //  address
 
I2C i2c(I2C_SDA, I2C_SCL);
 
 
Serial pc(SERIAL_TX, SERIAL_RX);

bool tmp102_write(uint8_t pointerReg, bool sendData, uint8_t data1, uint8_t data2){
    
    if(!sendData){
        return i2c.write(TMP102_ADDR, (char*) &pointerReg, 1, 0) == 0;
    }
    
    char buf[3];
    buf[0] = pointerReg;
    buf[1] = data1;
    buf[2] = data2;
    
    return i2c.write(TMP102_ADDR, buf, 3, 0) == 0;
    
}

bool tmp102_read(uint16_t* data){
    return i2c.read(TMP102_ADDR, (char*) data, 2, 0) == 0;
}

int tmp102_test(){
    int ret;
    uint16_t value;
    
    ret = tmp102_write(TMP102_REG_CONF, true, 0x60, 0x80);
    if(!ret) return -1;
    
    ret = tmp102_read(&value);
    if(!ret) return -2;
    
    ret = tmp102_write(TMP102_REG_TEMP, false, 0, 0);
    if(!ret) return -3;
    
    ret = tmp102_read(&value);
    if(!ret) return -4;
    
    return value;
}


// caculate temperatur in °C (works only for T > 0°C)
double tmp102_convertTemp(uint16_t data){
    uint16_t bin = (data >> 12) | (data << 4);
    return (double)bin * 0.0625;
}

int main()
{
 
    printf("Hello TMP102\n");
    while (1) {
        int res = tmp102_test();
        pc.printf("tmp102_test: %X\n", res);
        printf("converted: %f\n", tmp102_convertTemp(res));
        wait(1.0);
    }
 
}
 
 
