#include "mbed.h"
 
#define PCF8574_ADDR     (0x40) 
 
I2C i2c(I2C_SDA, I2C_SCL);
 
 
Serial pc(SERIAL_TX, SERIAL_RX);


bool pcf8574_write(uint8_t data){
    return i2c.write(PCF8574_ADDR, (char*) &data, 1, 0) == 0;
}

bool pcf8574_read(uint8_t* data){
    return i2c.read(PCF8574_ADDR, (char*) data, 1, 0) == 0;
}

int pcf8574_test(uint8_t value){
    int ret;
    uint8_t data=0;
    
    ret = pcf8574_write(value);
    if(!ret) return -1;
    
    ret = pcf8574_read(&data);
    if(!ret) return -2;
    
    return data;
}

int main()
{
 
    printf("Hello PCF8574\n");
    while (1) {
        pc.printf("pcf8574_test: low: %i\n", pcf8574_test(0x00));
        wait(0.5);
        pc.printf("pcf8574_test: high: %i\n", pcf8574_test(0xff));
        wait(0.5);
    }
 
}
 
 
