#include "mbed.h"

#define DAC_ADDR (0xc0)

I2C i2c(I2C_SDA, I2C_SCL);
 
 
Serial pc(SERIAL_TX, SERIAL_RX);

bool mcp4728_setChannel(uint8_t channel, bool UseInternalVRef, uint8_t powerDownMode, bool use2xGain, uint16_t value){
    char buf[3];
    buf[0] = 0x40 | ((channel & 0x3) << 1);
    
    buf[1] = ((uint8_t)UseInternalVRef << 7) | ((powerDownMode & 0x3) << 5) | ((uint8_t)use2xGain << 4);
    buf[1] |= (value & 0x0f00)>>8;
    
    buf[2] = value & 0xff;
    
    return i2c.write(DAC_ADDR, buf, 3, 0) == 0;
}

int dac_test(void){
    static uint16_t value = 0;
    int ret;
    
    ret = mcp4728_setChannel(0, 0, 0, 0, value);
    value++;
    if(!ret) return -2;
    
    return 1;
}

int main()
{
 
    printf("Hello DAC MCP4728\n");
    while (1) {
        pc.printf("dac_test: %i\n", dac_test());
        wait(0.1);
    }
 
}
 
