#include "mbed.h"

#define ADC_ADDR (0xD0)

I2C i2c(I2C_SDA, I2C_SCL);
 
 
Serial pc(SERIAL_TX, SERIAL_RX);
 
bool mcp3428_writeConfig(uint8_t conf){
    return i2c.write(ADC_ADDR, (char*) &conf, 1, 0) == 0;
}

bool mcp3428_read(uint16_t* data, uint8_t* conf){
    char buf[3];
    int ret = i2c.read(ADC_ADDR, buf, 3, 0);
    
    if(ret != 0)
        return false;
    
    *data = buf[0] << 8 | buf[1];
    *conf = buf[2];
    
    return true;
}

int adc_test(void){
    uint8_t conf = 0x90;
    uint16_t data = 0;
    
    if(!mcp3428_writeConfig(conf)) return -1;
    
    int ret = mcp3428_read(&data, &conf);
    
    if(!ret) return -2;
    
    return data;
    
    }

int main()
{
 
    printf("Hello ADC MCP3428\n");
    while (1) {
        pc.printf("adc_test: %i\n", adc_test());
        wait(1.0);
    }
 
}
 
