#include "mbed.h"

//Serial pc2(USBTX, USBRX);
I2C i2cTem(PB_9, PB_8); //i2c device constructor
//9E = 1001 1110
const int addr = 0x90;          //8 bit (addr|0) - all config bits=0 (floating)
                                                        //First 4 bits are 1001 (set by manufacturer)
int* ReadDS1621(void)
{
    char cmd[2];        // command buffer (re-usable)
    static int data[2] = {0, 0};      //data being read
        // AC = 1010 1100
    cmd[0] = 0xAC;
    i2cTem.write(addr, cmd, 1, false); // Access Config
        // 02 = 0000 0010
    cmd[0] = 0x02;  // 2 = continuous convert, POL=1
    i2cTem.write(addr, cmd, 1, false); //continuous conversions
        //pc2.printf("start %i:%i\n",(int)cmd[0],(int)cmd[1]);
    wait_ms(20);    // allow time for ee write  
        // EE = 1110 1110
    cmd[0] = 0xEE;  //238=start conversions - needs 10ms delay
    i2cTem.write(addr, cmd, 1, false); //try sending stop
        //pc2.printf("%i:%i\n",(int)cmd[0],(int)cmd[1]);
    wait_ms(20);  //20ms
        // AA = 1010 1010
    cmd[0] = 0xAA;  //to issue 'Read temp'
    i2cTem.write(addr, cmd, 1, false);
        //pc2.printf("%i:%i\n",(int)cmd[0],(int)cmd[1]);
    i2cTem.read(addr, cmd, 2, false);  
        //pc2.printf("%i:%i\n",(int)cmd[0],(int)cmd[1]);
        data[0] = (int)cmd[0]; 
        data[1] = (int)cmd[1];
      return (int*)data;
}
