#include "mbed.h"
#include "N5110.h"
#include "MMA8452.h"



N5110 lcd(p7,p8,p9,p10,p11,p13,p26);
MMA8452 mma8452(p28,p27);  // SDA, SCL
Serial serial(USBTX,USBRX);//serial port
InterruptIn button(p17);//button 
BusOut leds(p24);//led
Ticker buzzer_timer;//buzzer timer
PwmOut buzzer(p21);//buzzer

AnalogIn pot(p20);   /* Potentiometer middle pin connected to P0_11, other two ends connected to GND and 3.3V */




int fsm[4] = {1,2,4,8}; // simple FSM counter has 4 states
int state = 0; // initial state 0
// defines for direction
#define UP 0
#define DOWN 1
#define MID 2

int direction = UP; // initially count up

float frequency=659;


int k=0;

void buttonPressed() // toggle direction in ISR
{
    k++;
    
    direction=k%3;
    

}

int main()
    {
        lcd.init();
        mma8452.init();  // 100 Hz update rate, ±4g scale
        
        float ain;
        Acceleration acceleration;  // Accleration structure declared in MMA8452 class
        
            
        button.rise(&buttonPressed); // Use internal pullup for pushbutton   
            
    
            wait(.001);// Delay for initial pullup to take effect
            

        while(1)
        {   
            
            acceleration = mma8452.readValues();// read current values and print over serial port
            
            
            
            //calculate the angle
            float angleX = atan(acceleration.x/sqrt(pow(acceleration.y,2)+pow(acceleration.z,2)))*64;
            float angleY = atan(acceleration.y/sqrt(pow(acceleration.x,2)+pow(acceleration.z,2)))*64;
            float angleZ = atan(acceleration.z/sqrt(pow(acceleration.y,2)+pow(acceleration.x,2)))*64;
               
            
              
            //store the acceleration data
            char buffer1[14];
            int length = sprintf(buffer1,"x = %.2f g",acceleration.x);
            char buffer2[14];
            length = sprintf(buffer2,"y = %.2f g",acceleration.y);
            char buffer3[14];
            length = sprintf(buffer3,"z = %.2f g",acceleration.z);
            
        
                
            
            //store angle data
            char buffer4[14];
            length = sprintf(buffer4,"X=%.3gDegree",angleX);
            char buffer5[14];
            length = sprintf(buffer5,"Y=%.3gDegree",angleY);
            char buffer6[14];
            length = sprintf(buffer6,"Z=%.3gDegree",angleZ);
            char buffer7[14];
            length = sprintf(buffer7,"ACCELEROMETER");
            char buffer8[14];
            length = sprintf(buffer8,"PROTRACTOR");
            char buffer9[14];
            length = sprintf(buffer9,"Y");
            char buffer10[14];
            length = sprintf(buffer10,"X");
            
            
             
           
                wait(0.1);
                lcd.clear();       
             
                
               
                if (angleY>=90||angleY<=-90||angleX>=90||angleX<=-90){
                 
                    buzzer.period(1/frequency); // set PWM period
                    buzzer=0.5; // set duty cycle
                  
                    
                 } 
                    
                
                else  
                {   
                        buzzer.period(1/frequency); // set PWM period
                        buzzer=0; // set duty cycle                  
                    }
                    
                    
              
                
                switch(direction)//button case when pressed
                {
                    case UP://first pressed
                        direction = 0;
                        lcd.printString(buffer7,4,0);
                        lcd.printString(buffer1,3,2);
                        lcd.printString(buffer2,3,3);
                        lcd.printString(buffer3,3,4);
                        break;
                    
                    case DOWN://second pressed
                        direction = 1;
                        lcd.printString(buffer8,13,0);
                        lcd.printString(buffer4,3,2);
                        lcd.printString(buffer5,3,3);
                        lcd.printString(buffer6,3,4);
                        break;
                    case MID://third presssed
                        direction = 2;
                        
                        // x0,y0,x1,y1,type 0-white,1-black,2-dotted
                        lcd.drawLine(0,23,83,23,1);
                        
                        lcd.drawLine(41,0,41,48,1);
                        
                        lcd.drawLine(64,0,17,47,1);
                        
                        lcd.drawLine(18,0,65,47,1);
                        
                        lcd.drawCircle(41,23,13,0);  // x,y,radius,black fill
                        lcd.drawCircle(41,23,25,0);
                        
                   
                            if (angleX<0||angleY>0){    //move right and forward
                           
                                
                            lcd.setPixel(41-angleX/3.6,23+angleY/3.6);
                            lcd.setPixel(41-angleX/3.6,22+angleY/3.6);
                            lcd.setPixel(41-angleX/3.6,24+angleY/3.6);
                            lcd.setPixel(42-angleX/3.6,23+angleY/3.6);
                            lcd.setPixel(40-angleX/3.6,23+angleY/3.6);
                            
                            }
                            lcd.refresh();
                        
                          
                    
                            
                        if (angleX>0||angleY>0)  //move left and backward
                        {
                            lcd.setPixel(41-angleX/3.6,23+angleY/3.6);
                            lcd.setPixel(41-angleX/3.6,22+angleY/3.6);
                            lcd.setPixel(41-angleX/3.6,24+angleY/3.6);
                            lcd.setPixel(40-angleX/3.6,23+angleY/3.6);
                            lcd.setPixel(42-angleX/3.6,23+angleY/3.6);
                            
                            lcd.refresh();
                            
                            }
                        
                        
                        lcd.printString(buffer9,35,0);
                        lcd.printString(buffer10,75,2);
                        
                        break;
                    
                        
                    default:
                        
                        break;
                    
                }   
                    
                leds=1;
            
            ain = pot.read(); /* Read analog value (output will be any value between 0 and 1 */
          
                
                lcd.setBrightness(ain);  //tune the screen brightness
                lcd.refresh();  
              
             
        }
}

