#include <stdio.h>
#include <time.h>
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#define length 100
#define SNAKE_SIZE 2 

/////////////// objects /////////////// 
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad pad;
 
//////////STRUCTURE///////////////
struct Coor {
    int x;
    int y;    
}COOR;//define the variable of snake coordinate
 
struct Snake {
    Coor snakezb[length]; //the max length of snake, every section length of snake
    int n;   //number of snake points   
}SNAKE;
struct Food{
   Coor fc;//define the variable of food coordinate
}food;
 
/** main Class
@author WangLin, University of Leeds
@brief all the functions of Snake game
@date May 2019
*/

/**define the body coordinate of snake*/ 
void defineSnake();
/**the music module*/
void sound();
/**draw snake
@param the coor(N5110&lcd)
 */
void DrawSnake();
/**make snake to move to different direction
@param direction(int Dir)
 */
void MoveSnake();
/** generate a new food when the previous food has been eated
*/
void RespawnFood();
/**when snake dead print gameover and guide to restart
*/
void DeadSnake();
float waittime;
int Score ;
int live; // Snake's live, if live=0, break the loop.
int Dir;
Direction d;

 
 
 // define the coordinate of the body of snake
 void defineSnake(){
     for(int i = 1; i < SNAKE.n; i++){
         SNAKE.snakezb[i].x = SNAKE.snakezb[i-1].x;
         SNAKE.snakezb[i].y = SNAKE.snakezb[i-1].y-1;//draw snake from top to bottom
         }
     }

 
//draw a snake by through the whole array
void DrawSnake()
{
        
        for(int i = 0; i < SNAKE.n; i++){
        lcd.drawRect(SNAKE.snakezb[i].x,SNAKE.snakezb[i].y,1,1,FILL_BLACK);
        }
    
    
}
 
//implement the movement function
void MoveSnake()
{
    d = pad.get_direction();//get the direction from joystick
    //get the direction from the button 
    //prepare for move
    if (pad.check_event(Gamepad::Y_PRESSED) || d == N){
        Dir = 1;//up
        }
    else if (pad.check_event(Gamepad::A_PRESSED) || d == S){
        Dir = 2;//down
        }
    else if (pad.check_event(Gamepad::X_PRESSED) || d == W){
        Dir = 3;//left
        }
    else if (pad.check_event(Gamepad::B_PRESSED) || d == E){
        Dir = 4;//right
        }
// the main  statement to run the snake
//to let the coordinate of the snake equals to the previous section
//so the move statement only need to change the first section snake's coordinate
    for(int i = SNAKE.n; i >0; i--){
        SNAKE.snakezb[i].x = SNAKE.snakezb[i-1].x;
        SNAKE.snakezb[i].y = SNAKE.snakezb[i-1].y;
        }
    //let snake move for different direction
    if (Dir == 1 && Dir != 2){
        SNAKE.snakezb[0].x = SNAKE.snakezb[0].x;
        SNAKE.snakezb[0].y = SNAKE.snakezb[0].y-1;
        }//move up
    else if (Dir == 2 && Dir != 1){
        SNAKE.snakezb[0].x = SNAKE.snakezb[0].x;
        SNAKE.snakezb[0].y = SNAKE.snakezb[0].y+1;
        }//move down
    else if (Dir == 3 && Dir != 4){
        SNAKE.snakezb[0].x = SNAKE.snakezb[0].x-1;
        SNAKE.snakezb[0].y = SNAKE.snakezb[0].y;
        }//move left
    else if (Dir == 4 && Dir != 3){
        SNAKE.snakezb[0].x = SNAKE.snakezb[0].x+1;
        SNAKE.snakezb[0].y = SNAKE.snakezb[0].y;
        }//move right
    
 }

//generate a radom food
void SpwanFood(){
    srand(unsigned (time(NULL)));
    food.fc.x = rand() % 80; // get a radom number for the coordinate of food.
    food.fc.y = rand() % 40;
    
    }
//print the food
void drawFood(){
    lcd.drawRect(food.fc.x,food.fc.y,1,1,FILL_BLACK);
    }
//juge if snake eat food, length increased, score +1 , play sound effect.
void EatFood(){
//juge if snake eat food
    if(SNAKE.snakezb[0].x == food.fc.x && SNAKE.snakezb[0].y == food.fc.y ){
        SNAKE.n = SNAKE.n+5;
       SpwanFood();//generate a new food after the previous food had been eated
       pad.tone(650,0.5);// sound effect
       Score = Score +1;// score+1
       char buffer[1];
       sprintf(buffer,"%d",Score);
       lcd.printString(buffer,70,1);//print score
        }
    }
//juge if snake hit the map border or itself, if hitted then break loop, jump to the DeadSnake mode.
void Break(){
    //check if snake hit the map border
    if(SNAKE.snakezb[0].x<=0 || SNAKE.snakezb[0].x >= 83 || SNAKE.snakezb[0].y <= 0  || SNAKE.snakezb[0].y >= 47)
    {
        live = 0;
        
        }
       //check if the snake hit itself 
        for(int i = SNAKE.n-2; i > 0; i--){
           if( SNAKE.snakezb[0].x == SNAKE.snakezb[i].x && SNAKE.snakezb[0].y == SNAKE.snakezb[i].y){
            live =  0;
            
            }
            }
    }

//if snake dead,print gameover page and a passway to resart
void DeadSnake(){
    lcd.clear();
    lcd.printString("GAME  OVER",0,1 );
    lcd.printString("YOUR SCORE:",0,2);
    lcd.printString("Press Back",1,4);
    lcd.printString("TO Resart",1,5);
    char buffer[1];
    sprintf(buffer,"%d",Score);
    lcd.printString(buffer,65,2);
    lcd.refresh();
    sound();
    
    
    }
// the sound moudle
void sound(){
    pad.tone(440.0,0.25);
       wait(0.27);
       pad.tone(659,0.25);
        wait(0.27);
       pad.tone(659,0.25);
       wait(0.27);
       pad.tone(440.0,0.25);// 及你太美
       wait(0.85);
       pad.tone(440.0,0.25);
       wait(0.2);
       pad.tone(440.0,0.25);// baby
       wait(0.85);
       pad.tone(440.0,0.25);
       wait(0.27);
       pad.tone(659,0.25);
        wait(0.27);
       pad.tone(659,0.25);
       wait(0.27);
       pad.tone(440.0,0.25);
       wait(0.85);
       pad.tone(440.0,0.25);
       wait(0.2);
       pad.tone(440.0,0.25);
       wait(0.8);
    }