#include "mbed.h"
#include "TextLCD.h"
 
Ticker timer;               //Timer para actualizar la hora
Ticker timerLCD;            //Timer para imprimir en pantalla
TextLCD lcd(D2,D3,D4,D5,D6,D7);

DigitalOut col1 (D8);
DigitalOut col2 (D9);
DigitalOut col3 (D10);
DigitalIn fila1 (A5);
DigitalIn fila2 (A4);
DigitalIn fila3 (A3);
DigitalIn fila4 (A2);
               
int sec=0;  //conteo de segundo
int min=0;  //conteo de minutos
int hora=0; //conteo de horas
int dia=0;  //conteo de dias
int mes=0;  //conteo de meses
int ano=0;  //conteo de años

void calendario();
void mostrarFecha();
void apagarTeclado();
int teclado();

int main() {
    int x;
    while(1){   //primero vamos a pedir el año al usuario
    lcd.locate(0,0);    //localiza la pantalla en el primer renglon y primera columna
    lcd.printf("Ano: (# enter)");   
    x = teclado();  //detecta el numero ingresado por el usuario
    wait(.25);  //espera para el rebote del teclado
    if (x == 11)    //Esta tecla es el enter, sale del while
        {
            break;
        }
    if (x == 10)    //Esta tecla no hace nada, por lo tanto si se preciona no se hace nada
        {}
    else
    {
    ano = (ano*10) + x; //Multiplica por 10 el valor previo para agregar el siguiente digito al final
    }
    lcd.locate(0,1);    // Localiza la pantalla en la segunda columna
    lcd.printf("%d",ano);   //imprime el valor ingresado por el usuario
    }
    
    lcd.cls();  //limpiamos la pantalla y repetirmos para mes, dia, hora y minutos
    
    while(1){   //meses
    lcd.locate(0,0);
    lcd.printf("Mes: (# enter)");
    x = teclado();
    wait(.25);
    if (x == 11)
        {
            break;
        }
    if (x == 10)
        {}
    else
    {
    mes = (mes*10) + x;
    }
    lcd.locate(0,1);
    lcd.printf("%d",mes);
    }
    
    lcd.cls();
    
    while(1){   //dias
    lcd.locate(0,0);
    lcd.printf("Dia: (# enter)");
    x = teclado();
    wait(.25);
    if (x == 11)
        {
            break;
        }
    if (x == 10)
        {}
    else
    {
    dia = (dia*10) + x;
    }
    lcd.locate(0,1);
    lcd.printf("%d",dia);
    }
    
    lcd.cls();
    
    while(1){   //horas
    lcd.locate(0,0);
    lcd.printf("Hora: (# enter)");
    x = teclado();
    wait(.25);
    if (x == 11)
        {
            break;
        }
    if (x == 10)
        {}
    else
    {
    hora = (hora*10) + x;
    }
    lcd.locate(0,1);
    lcd.printf("%d",hora);
    }
    
    lcd.cls();
    
    while(1){   // minutos
    lcd.locate(0,0);
    lcd.printf("Min: (# enter)");
    x = teclado();
    wait(.25);
    if (x == 11)
        {
            break;
        }
    if (x == 10)
        {}
    else
    {
    min = (min*10) + x;
    }
    lcd.locate(0,1);
    lcd.printf("%d",min);
    }
    
    ////////////////////////////////////////////////////////////////
    
    lcd.locate(0,1);
    timer.attach(&calendario, 1);       //es el timer que llama a la funcion que actualiza la fecha, el 1 significa que se llama cada segundo
    timerLCD.attach(&mostrarFecha, .1); //Este timer se usa para actualizar la pantalla, la funcion se llama cada 0.1 segundos
    //El timer del calendario puede ser llamado mucho mas rapido que el de la pantalla, asi logramos que el tiempo pase mas rapido
    //La pantalla debe estar aparte ya que necesita cierto tiempo para poder mostrar el mensaje, es por eso que no puede llamarse tan seguido
        
  }
  
int teclado()
{
    apagarTeclado();    //Apagamos el teclado al principio por si acaso
    while(1){           // Loop que se repetirá infinitamente
        
        col1 = 1;       // Polarizamos la primera columna
        if (fila1 == 1){    //Verificamos el estado de la fila 1
            return(1);//Si la fila 1 está encendida cuando la columna 1 fue
        }
        if (fila2 == 1){    //Verificamos el estado de la fila 2
            return(4);//Si esta encendida imprimimos un 4
        }
        if (fila3 == 1){
            return(7);
        }
        if (fila4 == 1){
            return(10);
        }
        apagarTeclado();    //Apagamos todas las columnas 
        col2 = 1;           // Encendemos la siguiente columna y repetimos
        if (fila1 == 1){
            return(2);
        }
        if (fila2 == 1){
            return(5);
        }
        if (fila3 == 1){
            return(8);
        }
        if (fila4 == 1){
            return(0);
        }
        apagarTeclado();
        col3 = 1;
        if (fila1 == 1){
            return(3);
        }
        if (fila2 == 1){
            return(6);
        }
        if (fila3 == 1){
            return(9);
        }
        if (fila4 == 1){
            return(11);
        }
        apagarTeclado();   
        }
}

void mostrarFecha() //Esta funcion solo se encarga de imprimir en pantalla
{   
    lcd.cls();
         
    lcd.printf("%02d/%02d/%02d",ano,mes,dia); //Todas las variables son globales
    lcd.locate(0,1);                            //Imprime la fecha arriba
    lcd.printf("%02d:%02d:%02d",hora,min,sec);   //imprime la hora abajo
}

void calendario()   //Esta funcion hace los calculos de fecha y hora
{
    sec=sec+1;  //Cada que se llama la funcion sumamos un segundo
      if(sec==60)   //A los 60 segundo sumamon un minutos y regresamos a 0 segundos
      {
          min=min+1;
          sec=00;
      }
      if(min==60)   //A los 60 minutos sumamos una hora y regresamos a 0 minutos
      {
        hora=hora+1;
        min=00;    
      }
      if(hora==24)  //A las 24 horas sumamos un dia y regresamos a 0 horas
      {
        hora=0;
        dia=dia+1;
      }
      if(mes==1||mes==3||mes==5||mes==7||mes==8||mes==10||mes==12) //Estos son los meses que tienen 31 dias
      {                                                           
      if(dia==32)   //A los 31 dias sumamos un mes y regresamos los dias a 1
        {
             dia=1;
             mes=mes+1;
         }
      }
      if(mes==4||mes==6||mes==9||mes==11) //Estos son los meses con 30 dias
      {
         if(dia==31)//A los 30 dias sumamos un mes y regresamos los dias a 1
         {
            dia=1;
            mes=mes+1;
          }
      }

         if(mes==2) //Es el unico mes con 28 dias
        {
     
            if(dia==29) //A los 28 dias sumamos un mes y regresamos los dias a 1
            {
                dia=1;
                mes=mes+1;
            }
        }
      
       if(mes==13)  //A los 12 meses sumamos un año y regresamos los meses a 1
      { 
        mes=1;
        ano=ano+1;
      }
}

void apagarTeclado()   
{
    col1 = col2 = col3 = 0;  //Apaga todas las columnas
}