#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(D2, D3, D4, D5, D6, D7); // rs, e, d4-d7

DigitalOut col1 (D8);
DigitalOut col2 (D9);
DigitalOut col3 (D10);
DigitalOut col4 (D11);
DigitalIn fila1 (A5);
DigitalIn fila2 (A4);
DigitalIn fila3 (A3);
DigitalIn fila4 (A2);
 
RawSerial Uart1(A0, A1);  // tx, rx Define los pines de la Uart a usar
 
char Simbolos[4][4] = {             //Matriz de caracteres del teclado
                     {'1','2','3','A'},
                     {'4','5','6','B'},
                     {'7','8','9','C'},
                     {'*','0','#','D'}
                     };   

volatile char Data[11];
volatile char Data2[11];     
             
int usrInput();
void turnOffteclado();
int * teclado();

void Uart1Rx_interrupt();
void Uart2Rx_interrupt();
 
int main() {
    
    int * Index;            //Da la ubicacion en la matriz de caracteres
    while (Simbolos[Index[0]][Index[1]] != '*')     //Espera a que el usuario ingrese * para comenzar
    {
        Index = teclado();
    }
    wait(.5);   
    
    Data2[0] = '\0'; //Vacia el primer espacio del arreglo
        
    lcd.cls();
    Uart1.baud(9600);    //define baudrate
    
    Uart1.attach(Uart1Rx_interrupt,Serial::RxIrq); //Indica que hay un interrup para la Uart
                                                    //Se activa cuando hay un dato en el pin Rx (receptor)
   
    while(1)
    {
        int i = 0;
        
    do  //Imprime en pantalla lo teclado (hasta 10 caracteres) y lo envia si se recibe un #
    {
        Index = teclado(); //Recibe el indice del caracter ingresado por el usuario
        if(i < 10 and Simbolos[Index[0]][Index[1]] != '#') //Si no se teclea un # 
        {
            if(i == 0){ //Si es el primer caracter (i = 0) se limpia el primer renglon de la pantalla
                lcd.locate(0,0);
        lcd.printf("                ");
        lcd.locate(0,0);
        }
            Data[i] = Simbolos[Index[0]][Index[1]]; //Guarda el valor ingresado por el usuario caracter por caracter
            lcd.printf("%c",Data[i]);   //Imprime el caracter ingresado
            wait(.15);
            i = i+1;    //Se mueve a la siguiente posicion de la matriz de datos
        }

    }while(Simbolos[Index[0]][Index[1]] != '#'); //Condicion para que se acabe el Do - while, si se ingresa un #
                            //Ya que sale del Do - While, la matriz Data tiene todos los caracteres ingresados por el usuario
    lcd.locate(0,1);            //Limpia el segundo renglon
    lcd.printf("                ");
    lcd.locate(0,1);
    for(int x = 0; x < i ; x += 1) //Envia dato por dato de la matriz Data al pin Tx de la Uart.
    {
    Uart1.putc(Data[x]);  //Putc envia el caracter de la matriz Data en posicion x
    wait(.025);             //esperamos un poco para asegurar que llegue el dato
    } 
    
    wait(.5);
        
    }
    
}

void Uart1Rx_interrupt()    //Este interrup se llama si llega algo al pin Rx de la Uart
{
    lcd.printf("%c",Uart1.getc());  //Imprime en pantalla el caracter que actualmente hay en el pin Rx de la Uart
    return;
}
 

int * teclado() 
{
    static int r[2];
    turnOffteclado();
    int numero;
  while(1) 
  {           
    col1 = 1;
    numero = usrInput();
    if (numero != 0)
    {
    r[0]=numero-1;
    r[1]=0;
    wait_ms(50);
    return r;
    }
    turnOffteclado();
    col2 = 1;
    numero = usrInput();
    if (numero != 0)
    {
    r[0]=numero-1;
    r[1]=1;
    wait_ms(50);
    return r;
    }
    turnOffteclado();
    col3 = 1;
    numero = usrInput();
    if (numero != 0)
    {
     r[0]=numero-1;
     r[1]=2;
     wait_ms(50);
     return r;
    }
    turnOffteclado();
    col4 = 1;
    numero = usrInput();
    if (numero != 0)
    {
     r[0]=numero-1;
     r[1]=3;
     wait_ms(50);
     return r;
    }
    turnOffteclado();
    
  }
}

void turnOffteclado()
{
    col1 = col2 = col3 = col4 = 0;
}
 
int usrInput()
{
    if (fila1 == 1)
    {
        return 1;
    }
    else if (fila2 == 1)
    {
        return 2;
    }
    else if (fila3 == 1)
    {
        return 3;
    }
    else if (fila4 == 1)
    {
        return 4;
    }  
    else{
    return 0;  
    }
}