#ifndef ZETA_STM_KINETIC_THREADDECLARATION_H_
#define ZETA_STM_KINETIC_THREADDECLARATION_H_
#include "mbedHeader.hpp"
#include "rosHeader.hpp"
#include "moduleHeader.hpp"
#include "variables/defineHeader.h"
#include "variables/instanceHeader.hpp"
#include "variables/globalVariable.h"
#include "configurations/robotConfig.h"
#include "myUtil.hpp"


/* Threads begin ------------------------------------------------------------ */
using myUtil::set_msg;
using myUtil::calibrationProcess;
using myUtil::applyCalbratedValue;
#if ((ROBOT_TYPE == MODEL_C) || (ROBOT_TYPE == MODEL_D))
//extern ChargingControl charging_control;
#endif
#ifdef NO_ROS
void print_thread() {
    const float time2print = 10.0;
    const float print_thread_hz = 3.0;
    waitTmr.start();
    while(waitTmr.read() < time2print) {;}
    waitTmr.stop();
    waitTmr.reset();
    while(true) {
        /*
        for(int i = 0; i < NUM_SONAR; i++) {
            //pc.printf("%2.2f\t%2.2f\t",dist[i],dist_raw[i]);
        }*/
        pc.printf("\n\r");
        pc.printf("Acc_x:%2.2f\tAcc_y:%2.2f\tAcc_z:%2.2f\n\r",
            gAcc_raw.x,gAcc_raw.y,gAcc_raw.z);
        pc.printf("Gyro_x:%2.2f\tGyro_y:%2.2f\tGyro_z:%2.2f\n\r",
            gGyro_raw.x,gGyro_raw.y,gGyro_raw.z);
        pc.printf("Mag_x:%2.2f\tMag_y:%2.2f\tMag_z:%2.2f\n\r",
            gMag_raw.x,gMag_raw.y,gMag_raw.z);
        pc.printf("quaternion: %2.2f  %2.2f  %2.2f  %2.2f\n\r",
            gQ[0],gQ[1],gQ[2],gQ[3]);
        pc.printf("RPY: %2.2f\t%2.2f\t%2.2f\n\r",gRoll,gPitch,gYaw);
        pc.printf("Theta_z: %2.2f degree\n\r", gTheta);
        ThisThread::sleep_for(1000/print_thread_hz);
    }    
}
#else

#if ((ROBOT_TYPE == MODEL_C) || (ROBOT_TYPE == MODEL_D))
void bt_pub_thread() {
    const float bt_pub_hz = 40.0;
    char seq_state_msg[SEQ_STATE_MSG_SIZE] = {'\0'};
    const char contact[] = "contact";
    const char BT_waiting[] = "BT_waiting";
    const char start[] = "start";
    const char search[] = "search";
    const char adjustment[] = "adjustment";
    const char guidance[] = "guidance";
    const char charging[] = "charging";
    const char finish[] = "finish";
    const char not_connected[] = "not_connected";
    const char left[] = "left";
    const char right[] = "right";
    const char disconnected[] = "disconnected";
    char* buff = NULL;
    enum class AUTO_CHARGE_STATE : int {
        start = 1,
        BT_waiting = 1,
        search,
        adjustment,
        guidance,
        charging,
        finish,
    };
    charging_control.off();
    //while(waitTmr.read() < 5.0) {;}
    while(1) {
        if(bt_data.rec == 0)
        {
            charging_control.off();
        }
        switch(NUC_sub_state) {
            case static_cast<int>(AUTO_CHARGE_STATE::start):
                if(bt_data.rec == 1 || bt_data.rec == 2) {
                    set_msg(seq_state_msg, start, sizeof(start));
                    bt_data.sen = 3;
                }
                else {
                    set_msg(seq_state_msg, BT_waiting, sizeof(BT_waiting));
                    bt_data.sen = 2;
                }
                charging_control.off();
                break;
            case static_cast<int>(AUTO_CHARGE_STATE::search):
                set_msg(seq_state_msg, search, sizeof(search));
                bt_data.sen = 4;
                break;
            case static_cast<int>(AUTO_CHARGE_STATE::adjustment):
                set_msg(seq_state_msg, adjustment, sizeof(adjustment));
                bt_data.sen = 5;
                break;
            case static_cast<int>(AUTO_CHARGE_STATE::guidance):
                set_msg(seq_state_msg, guidance, sizeof(guidance));
                bt_data.sen = 6;
                break;
            case static_cast<int>(AUTO_CHARGE_STATE::charging):
                set_msg(seq_state_msg, charging, sizeof(charging));
                bt_data.sen = 7;
                break;
            case static_cast<int>(AUTO_CHARGE_STATE::finish):
                set_msg(seq_state_msg, finish, sizeof(finish));
                charging_control.off();
                bt_data.sen = 8;
                break;    
        }
        
        if(strstr(seq_state_msg,guidance) != NULL) {
            switch(bt_data.rec) {
                case 69:
                    set_msg(seq_state_msg, contact, sizeof(contact));
                    break;
                case 66:
                    set_msg(seq_state_msg, left, sizeof(left));
                    break;
                case 63:
                    set_msg(seq_state_msg, right, sizeof(right));
                    break;
                default:
                    set_msg(seq_state_msg, not_connected, sizeof(not_connected));
                    charging_control.off();
                    break;
            }
        }
        else if(strstr(seq_state_msg,charging) != NULL) {
            switch(bt_data.rec) {
                case 79:
                    set_msg(seq_state_msg, contact, sizeof(contact));
                    charging_control.on();
                    break;
                default:
                    set_msg(seq_state_msg, disconnected, sizeof(disconnected));
                    charging_control.off();
            }    
        }
        Bluetooth_msg.data = seq_state_msg;
        Bluetooth_publisher.publish(&Bluetooth_msg);
        nh.spinOnce();
        ThisThread::sleep_for(1000/bt_pub_hz);
    }
}
#elif (ROBOT_TYPE == MODEL_I)
void bt_pub_thread() {
    const float bt_pub_hz = 40.0;
    char seq_state_msg[SEQ_STATE_MSG_SIZE] = {'\0'};
    const char contact[] = "contact";
    const char BT_waiting[] = "BT_waiting";
    const char start[] = "start";
    const char search[] = "search";
    const char adjustment[] = "adjustment";
    const char guidance[] = "guidance";
    const char charging[] = "charging";
    const char finish[] = "finish";
    const char not_connected[] = "not_connected";
    const char left[] = "left";
    const char right[] = "right";
    const char disconnected[] = "disconnected";
    char* buff = NULL;
    enum class AUTO_CHARGE_STATE : int {
        start = 1,
        BT_waiting = 1,
        search,
        adjustment,
        guidance,
        charging,
        finish,
    };
    ChargingSsr = 0;
    //while(waitTmr.read() < 5.0) {;}
    while(1) {
        switch(NUC_sub_state) {
            case static_cast<int>(AUTO_CHARGE_STATE::start):
                if(bt_data.rec == 1 || bt_data.rec == 2) {
                    set_msg(seq_state_msg, start, sizeof(start));
                    bt_data.sen = 3;
                }
                else {
                    set_msg(seq_state_msg, BT_waiting, sizeof(BT_waiting));
                    bt_data.sen = 2;
                }
                ChargingSsr = 0;
                break;
            case static_cast<int>(AUTO_CHARGE_STATE::search):
                set_msg(seq_state_msg, search, sizeof(search));
                bt_data.sen = 4;
                break;
            case static_cast<int>(AUTO_CHARGE_STATE::adjustment):
                set_msg(seq_state_msg, adjustment, sizeof(adjustment));
                bt_data.sen = 5;
                break;
            case static_cast<int>(AUTO_CHARGE_STATE::guidance):
                set_msg(seq_state_msg, guidance, sizeof(guidance));
                bt_data.sen = 6;
                break;
            case static_cast<int>(AUTO_CHARGE_STATE::charging):
                set_msg(seq_state_msg, charging, sizeof(charging));
                bt_data.sen = 7;
                break;
            case static_cast<int>(AUTO_CHARGE_STATE::finish):
                set_msg(seq_state_msg, finish, sizeof(finish));
                ChargingSsr = 0;
                bt_data.sen = 8;
                break;    
        }
        
        if(strstr(seq_state_msg,guidance) != NULL) {
            switch(bt_data.rec) {
                case 69:
                    set_msg(seq_state_msg, contact, sizeof(contact));
                    break;
                case 66:
                    set_msg(seq_state_msg, left, sizeof(left));
                    break;
                case 63:
                    set_msg(seq_state_msg, right, sizeof(right));
                    break;
                default:
                    set_msg(seq_state_msg, not_connected, sizeof(not_connected));
                    ChargingSsr = 0;
                    break;
            }
        }
        else if(strstr(seq_state_msg,charging) != NULL) {
            switch(bt_data.rec) {
                case 79:
                    set_msg(seq_state_msg, contact, sizeof(contact));
                    ChargingSsr = 1;
                    break;
                default:
                    set_msg(seq_state_msg, disconnected, sizeof(disconnected));
                    ChargingSsr = 0;
            }    
        }
        Bluetooth_msg.data = seq_state_msg;
        Bluetooth_publisher.publish(&Bluetooth_msg);
        nh.spinOnce();
        ThisThread::sleep_for(1000/bt_pub_hz);
    }
}
#endif

void imu_pub_thread() {
    const float imu_pub_hz = 100.0;
//    const float imu_pub_hz = 50.0;
    imu_msg.header.frame_id = "imu_link";
    //mag_msg.header.frame_id = "/imu/mag";
    waitTmr.start();
    while(waitTmr.read() < 5.0) {;}
    while(1) {
        imu_msg.header.stamp = nh.now();
        imu_msg.orientation.w = gQ[0];
        imu_msg.orientation.x = gQ[1];
        imu_msg.orientation.y = gQ[2];
        imu_msg.orientation.z = gQ[3];
              
        imu_msg.angular_velocity.x = gGyro_raw.x;
        imu_msg.angular_velocity.y = gGyro_raw.y;
        imu_msg.angular_velocity.z = gGyro_raw.z;
        
        imu_msg.linear_acceleration.x = gAcc_raw.x;
        imu_msg.linear_acceleration.y = gAcc_raw.y;
        imu_msg.linear_acceleration.z = gAcc_raw.z;
        
        IMU_publisher.publish(&imu_msg);
        nh.spinOnce();
        
        ThisThread::sleep_for(1000/imu_pub_hz);
    }
}

void sonar_pub_thread() {
    const float sonar_pub_hz = 15.0;
    int ii = 0;
    for(;ii < NUM_SONAR; ii++) {
        US_msg.data[ii] = 0.0; 
    }
    while(waitTmr.read() < 5.0) {;}
    while(1) {
        //memcpy(US_msg.data, (float*)dist, sizeof(float)*NUM_SONAR);
        for(ii = 0;ii < NUM_SONAR; ii++) {
            US_msg.data[ii] = dist[ii]; 
        }
        US_publisher.publish(&US_msg);
        nh.spinOnce();
        ThisThread::sleep_for(1000/sonar_pub_hz);
    }  
}

void estop_pub_thread() {
    const float estop_pub_hz = 10; // ms
#if (ROBOT_TYPE == MODEL_I)
    LidarStopPin.mode(PullDown);
    EmergencyStopPin.mode(PullDown);
#endif
    while(waitTmr.read() < 5.0) {;}
    while(1) {
#if ((ROBOT_TYPE == MODEL_D) || (ROBOT_TYPE == MODEL_C))
        EStop_msg.data = estop;
        EStop_publisher.publish(&EStop_msg);
        //Bumper_publisher.publish(&Bumper_msg);
        nh.spinOnce();
#elif (ROBOT_TYPE == MODEL_I)
        uint8_t stop_status = 0;
        if(LidarStopPin)
        {
            stop_status += (0b1 << 0);
        }
        if(EmergencyStopPin)
        {
            stop_status += (0b1 << 1);
        }
        emergency_stop_msg.data = stop_status;
        EmergencyStop_publisher.publish(&emergency_stop_msg);
        nh.spinOnce();
#endif
        ThisThread::sleep_for(1000/estop_pub_hz);
    }   
}

#if (ROBOT_TYPE == MODEL_D)
void level_sensor_thread()
{
    const float level_pub_hz = 1;
    /*
    bool yellow,blue = true;
    while(1)
    {
        water_level_msg.data = 0;
        blue = level_blue;
        yellow = level_yellow;
        if(!blue)
        {
            water_level_msg.data += 1;
        }
        if(!yellow)
        {
            water_level_msg.data += 1;
        }
        water_level_publisher.publish(&water_level_msg);
        ThisThread::sleep_for(1000/level_pub_hz);
    }
    */
    bool sense = false;
    while(1)
    {
        if(level_sensor)
        {
            water_level_msg.data = true;
        }
        else
        {
            water_level_msg.data = false;
        }
        water_level_publisher.publish(&water_level_msg);
        ThisThread::sleep_for(1000/level_pub_hz);
    }
}
#endif

#if (ROBOT_TYPE == MODEL_I)
void lidar_dusty_pub_thread()
{
    const float lidar_dust_pub_hz = 10.0f;
    int dust_count = 0;
    LidarDustSensingPin.mode(PullUp);
    while(1)
    {
        if(!LidarDustSensingPin)
        {
            dust_count++;
        }
        else
        {
            dust_count = 0;
        }
        if(dust_count > 3)
        {
            lidar_dusty_msg.data = true;
        }
        else
        {
            lidar_dusty_msg.data = false;
        }
        LidarDusty_publisher.publish(&lidar_dusty_msg);
        ThisThread::sleep_for(1000/lidar_dust_pub_hz);
    }   
}
#endif
#endif /* #ifdef NO_ROS */

void bt_thread() {
    const float bt_thread_hz = 30.0f;
    const float bt_sen_hz    = 10.0f;
    const float bt_timeout   = 3.0f;
    char temp[2] = {'\0',};
    Timer bt_sen_tmr;
    Timer bt_timeout_tmr;
    bt_sen_tmr.start();
    bt_timeout_tmr.start();
    while(1)
    {
        if(bt.readable())
        {
            bt_data.rec = bt.getc();
            bt_timeout_tmr.reset();
            bt_timeout_tmr.start();
        }
        if(bt_sen_tmr.read() > (1.0 / bt_sen_hz))
        {
            bt_sen_tmr.reset();
            bt.putc(bt_data.sen);
        }
        if(bt_timeout_tmr.read() > bt_timeout)
        {
            bt_timeout_tmr.stop();
            bt_data.rec = 0;
            bt_data.sen = 0;
        }
        ThisThread::sleep_for(1000/bt_thread_hz);
    }
}

void sonar_thread() {
    const float sonar_hz = 15.0;
    sonar_manager.Begin(sonar_hz);
    while(true) {
        sonar_manager.GetDistance(dist);
        ThisThread::sleep_for(1000/sonar_hz);
    }
}

#define CALIBRATION_MODE 1
void IMU_thread() {
    const float imu_hz = 100.0;
    Vect3  a, g, m;
    mpu.setup();
    mpu.enableDataReadyInterrupt();
    #if (CALIBRATION_MODE)
    calibrationProcess();
    #endif
    applyCalbratedValue();
    
    memset(gQ,0.,4*sizeof(float));
    
    while(true){
        if (mpu.isDataReady()){
            Vect3  a, g, m;  // acc/gyro/mag vectors
            mpu.update(MADGWICK);
            a = mpu.getAccelVect();
            
            
            a.x = 0.0;
            a.y = 0.0;
            a.z = 1.0;
            
            
            g = mpu.getGyroVect();
            m = mpu.getMagVect();
#ifdef NO_ROS 
            gAcc_raw.x = a.x*G;
            gAcc_raw.y = a.y*G;
            gAcc_raw.z = a.z*G;
            gGyro_raw.x = g.x*DEG_TO_RAD;
            gGyro_raw.y = g.y*DEG_TO_RAD;
            gGyro_raw.z = g.z*DEG_TO_RAD;
            gQ[0] = mpu.getq0();
            gQ[1] = mpu.getq1();
            gQ[2] = mpu.getq2();
            gQ[3] = mpu.getq3();
            gRoll = mpu.getRoll()*RAD_TO_DEG;
            gPitch = mpu.getPitch()*RAD_TO_DEG;
            gYaw = mpu.getYaw()*RAD_TO_DEG;
            gTheta = atan2f(gQ[1] * gQ[2] + gQ[0] * gQ[3], 0.5f - gQ[2] * gQ[2] - gQ[3] * gQ[3]) * RAD_TO_DEG;
#else   //   ros
            mpu.update(MADGWICK);
            a = mpu.getAccelVect();
            g = mpu.getGyroVect();
            m = mpu.getMagVect();
            
            gAcc_raw.x = a.x*G;
            gAcc_raw.y = a.y*G;
            gAcc_raw.z = a.z*G;
            gGyro_raw.x = g.x*DEG_TO_RAD;
            gGyro_raw.y = g.y*DEG_TO_RAD;
            gGyro_raw.z = g.z*DEG_TO_RAD;
            
            //gMag_raw.x = m.x; // not use for our robot
            //gMag_raw.y = m.y;
            //gMag_raw.z = m.z;
            //gRoll = mpu.getRoll()*RAD_TO_DEG;
            //gPitch = mpu.getPitch()*RAD_TO_DEG;
            //gYaw = mpu.getYaw()*RAD_TO_DEG;
            
            gQ[0] = mpu.getq0();
            gQ[1] = mpu.getq1();
            gQ[2] = mpu.getq2();
            gQ[3] = mpu.getq3();
            //gTheta = atan2f(gQ[1] * gQ[2] + gQ[0] * gQ[3], 0.5f - gQ[2] * gQ[2] - gQ[3] * gQ[3]) * RAD_TO_DEG;
            //char myStr[64] = {'\0',};
            //sprintf(myStr,"theta: %f\troll: %f\tpitch: %f\tyaw: %f",gTheta,gRoll,gPitch,gYaw);
            //nh.loginfo(myStr);
#endif
        }
        ThisThread::sleep_for(1000/imu_hz);
    }
}

void test_thread() {
    while(true) {
        bt.putc('a');
        ThisThread::sleep_for(10);
        if(bt.readable())
        {
            char debug_str[6];
            sprintf(debug_str,"%c",bt.getc());
            nh.loginfo(debug_str);
            nh.spinOnce();
        }
        ThisThread::sleep_for(500);
    }   
}

/* Threads end -------------------------------------------------------------- */
#endif
