#ifndef ZETA_STM_KINETIC_MODULE_H_
#define ZETA_STM_KINETIC_MODULE_H_

#include <zetabot_main/ModuleControlMsgs.h>
#include "pinConfig.h"

// | pump | sol | uvc | sonar_UF | sonar_UR | sonar_UB | sonar_UL | sonar_DF | sonar_DR | sonar_DB | sonar_DL |
#define PUMP_ON_POS 0
#define SOL_ON_POS  1
#define UVC_ON_POS  2
#include "ros.h"
extern ros::NodeHandle nh;

// this class control 4 modules
class MODULE {
    typedef unsigned int level_t;
    typedef bool run_status_t;
    private:
        level_t _PurifierFreq = 0U;
        zetabot_main::ModuleControlMsgs* msg;
    
        //const variables
        const int _On                     = 1;
        const int _Off                    = 0;
        const int _PumpOn                 = 1;
        const int _PumpOff                = 0;
        const int _Brake                  = 1;
        const uint16_t _PurifierStop      = 0U;
        const bool _Run                   = true;
        const bool _Stop                  = false;
        
        DigitalOut boosterpump;
        DigitalOut solenoid;
        PwmOut purifier_pwmout;
        DigitalOut purifier_br;
        DigitalOut uvc;
        
    public: 
        MODULE(PinName boosterpump_pin, PinName solenoid_pin, PinName purifier_pwmpin, PinName purifier_brpin, PinName uvc_pin):
            boosterpump(boosterpump_pin,_PumpOff), solenoid(solenoid_pin,_PumpOff), purifier_pwmout(purifier_pwmpin),
            purifier_br(purifier_brpin, _Brake), uvc(uvc_pin,_Off){Init();}
        void InitPulifier();
        void InitDCE();
        void InitUVC();
        void Init();
        void SetPurifierFreq();
        void ControlPurifier();
        void ControlUVC();
        void ControlDCE();
        void setMsg(zetabot_main::ModuleControlMsgs* msg);
        void SetLevel();
        void control();
};

#endif
// EOF
