#ifndef ZETA_STM_KINETIC_CHARGINGCONTROL_H_
#define ZETA_STM_KINETIC_CHARGINGCONTROL_H_
#include "mbed.h"
#define SSR_OFF 1
#define SSR_ON  0

#include <ros.h>
extern ros::NodeHandle nh;

class ChargingControl {
    public:
        ChargingControl(PinName pinP, PinName pinN) : _pinP(pinP,SSR_OFF), _pinN(pinN,SSR_OFF) {}
        void on()
        {
            if(_pinN == SSR_OFF)
            {
                //nh.loginfo("ssr on");
                _pinN = SSR_ON;
                //ThisThread::sleep_for(100);
                _pinP = SSR_ON;
            }
        }
        void off()
        {
            if(_pinP == SSR_ON)
            {
                //nh.loginfo("ssr off");
                _pinP = SSR_OFF;
                //ThisThread::sleep_for(100);
                _pinN = SSR_OFF;
            }
        }
    private:
        void init();
        DigitalOut _pinP;
        DigitalOut _pinN;
};

#endif /* ZETA_STM_KINETIC_CHARGINGCONTROL_H_ */