#ifndef ZETA_STM_KINETIC_INITFUNCTION_H_
#define ZETA_STM_KINETIC_INITFUNCTION_H_
#include "mbed.h"
#include "threadDeclaration.hpp"
#include "variables/instanceHeader.hpp"
#include "rosHeader.hpp"
#include "configurations/robotConfig.h"
void initThread() {
    int index = 0;
    gThread[index++].start(IMU_thread);
    gThread[index++].start(bt_thread);
    gThread[index++].start(sonar_thread);
    gThread[index++].start(sonar_pub_thread);
    gThread[index++].start(bt_pub_thread);
#ifdef NO_ROS
    gThread[index++].start(print_thread);
#else
    //gThread[3].start(module_thread);
    gThread[index++].start(imu_pub_thread);
    gThread[index++].start(estop_pub_thread);
#if (ROBOT_TYPE == MODEL_D)
    gThread[index++].start(level_sensor_thread);
#endif
#if (ROBOT_TYPE == MODEL_I)
    gThread[index++].start(lidar_dusty_pub_thread);
#endif
#endif /* #ifdef NO_ROS */
    //gThread[8].start(test_thread);
}

void initBT() {
    bt.baud(9600);
    bt_data.rec = '\0';
    bt_data.sen = '\0';
}

#ifdef NO_ROS
void initSerial() {
    pc.baud(115200);
}
#else
void initROS() {
    nh.getHardware()->setBaud(ROSSERIAL_BUADRATE);
    nh.initNode();
    US_msg.data = (float*)malloc(sizeof(float) * NUM_SONAR);
    US_msg.data_length = NUM_SONAR;
    nh.advertise(IMU_publisher);
    nh.advertise(EStop_publisher);
    //nh.advertise(Bumper_publisher);
    nh.advertise(US_publisher);
    nh.advertise(Bluetooth_publisher);
    nh.subscribe(Bluetooth_subscriber);
    nh.subscribe(SsrTest_subscriber);
#if (ROBOT_TYPE == MODEL_D)
    nh.advertise(water_level_publisher);
#endif
#if (ROBOT_TYPE == MODEL_I)
    nh.subscribe(ScrubberControl_subscriber);
    nh.advertise(LidarDusty_publisher);
    nh.advertise(EmergencyStop_publisher);
    nh.subscribe(WarningFieldSelect_subscriber);
    nh.subscribe(IgnoreWarningField_subscriber);
#endif
    while(!nh.connected()) nh.spinOnce();
    waitTmr.start();
    nh.loginfo(__FW_VERSION__);
}
#endif

#endif
