#ifndef ZETA_STM_KINETIC_CALLBACKHEADER_H_
#define ZETA_STM_KINETIC_CALLBACKHEADER_H_
#include "rosHeader.hpp"
#include "mbed.h"
#include "myUtil.hpp"
#include "configurations/robotConfig.h"
//extern std_msgs::Bool UVCcontrolMsg;
extern volatile bool isSubscribe;
extern volatile uint8_t NUC_sub_state;
extern ros::NodeHandle nh;
#if ((ROBOT_TYPE == MODEL_C) || (ROBOT_TYPE == MODEL_D))
extern ChargingControl charging_control;
#endif 
#if (ROBOT_TYPE == MODEL_I)
extern DigitalOut WaringFieldSelectPin1;
extern DigitalOut WaringFieldSelectPin2;
extern DigitalOut IgnoreWarningFieldPin1;
extern DigitalOut IgnoreWarningFieldPin2;
extern DigitalOut ScrubberControl;
extern DigitalOut ChargingSsr;
#endif

void BluetoothCB(const std_msgs::UInt8& msg)
{
    NUC_sub_state = msg.data;
}

void SsrTestCB(const std_msgs::Bool& msg)
{
#if ((ROBOT_TYPE == MODEL_C) || (ROBOT_TYPE == MODEL_D))
    if(msg.data)
    {
        charging_control.on();
    }
    else
    {
        charging_control.off();
    }
#elif (ROBOT_TYPE == MODEL_I)
    ChargingSsr = msg.data;
#endif
    ThisThread::sleep_for(1000);
}
    

#if (ROBOT_TYPE == MODEL_I)
void WarningFieldSelectCB(const std_msgs::UInt8& msg)
{
    const unsigned char pos_front = 0U;
    const unsigned char pos_rear  = 1U;
    enum warning_field_select_enum
    {
        field1 = 0,
        field2,
    };
    if(msg.data & (1U << pos_front))
    {
        WaringFieldSelectPin1 = 1;   
    }
    else
    {
        WaringFieldSelectPin1 = 0;   
    }
    if(msg.data & (1U << pos_rear))
    {
        WaringFieldSelectPin2 = 1;
    }
    else
    {
        WaringFieldSelectPin2 = 0;   
    }
}

void IgnoreWarningFieldCB(const std_msgs::UInt8& msg)
{
    const unsigned char pos_front = 0U;
    const unsigned char pos_rear  = 1U;
    enum warning_field_select_enum
    {
        field1 = 0,
        field2,
    };
    if(msg.data & (1U << pos_front))
    {
        IgnoreWarningFieldPin1 = 1;   
    }
    else
    {
        IgnoreWarningFieldPin1 = 0;   
    }
    if(msg.data & (1U << pos_rear))
    {
        IgnoreWarningFieldPin2 = 1;
    }
    else
    {
        IgnoreWarningFieldPin2 = 0;   
    }
}
void ScrubberControlCB(const std_msgs::Bool& msg)
{
    if(msg.data)
    {
        ScrubberControl = 1;
    }
    else
    {
        ScrubberControl = 0;
    }
}
#endif
#endif
