#include "MODULE.hpp"

void MODULE::Init() {
    InitDCE();
    InitPulifier();
    InitUVC();
}



void MODULE::InitPulifier() {
    purifier_pwmout.period(1);
    purifier_pwmout = 0.0; 
    purifier_br = _Brake;
}

void MODULE::InitDCE() {
    boosterpump = _PumpOff;
    solenoid = _PumpOff;
}

void MODULE::InitUVC() {
    uvc = _Off;
}

void MODULE::SetPurifierFreq() {
    _PurifierFreq = msg -> pulifier;
}

void MODULE::ControlPurifier() {
    static level_t _PurifierFreq_pre = _PurifierStop;
    SetPurifierFreq();
    if(_PurifierFreq != _PurifierFreq_pre ) {  // for processing optimization
        if(_PurifierFreq != _PurifierStop) {
            purifier_pwmout.period(1.0/(float)_PurifierFreq);
            purifier_pwmout = 0.5;
            purifier_br = 0;
        }
        else {
            purifier_pwmout = 0.0;
            purifier_br = _Brake;
        }
    }
    _PurifierFreq_pre = _PurifierFreq;
}


void MODULE::ControlDCE() {
    if(msg->module_power[PUMP_ON_POS]) boosterpump = _PumpOn;
    else boosterpump = _PumpOff;
    if(msg->module_power[SOL_ON_POS]) solenoid = _PumpOn;
    else solenoid = _PumpOff;
}

void MODULE::control() {
    ControlDCE();
    ControlUVC();
    ControlPurifier();
}

void MODULE::ControlUVC() {
    if(msg->module_power[UVC_ON_POS]) uvc = _On;
    else uvc = _Off;
}


void MODULE::setMsg(zetabot_main::ModuleControlMsgs* msg) {
    this -> msg = msg;
}

// EOF


